/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.rest.async;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

class GenericUtils {
    GenericUtils() {
    }

    static String toGenericSignature(Type type) {
        StringBuilder sb = new StringBuilder();
        GenericUtils.toGenericSignature(sb, type);
        return sb.toString();
    }

    static void toGenericSignature(StringBuilder sb, Type type) {
        if (type instanceof GenericArrayType) {
            sb.append("[");
            GenericUtils.toGenericSignature(sb, ((GenericArrayType)type).getGenericComponentType());
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            sb.append('L');
            sb.append(((Class)pt.getRawType()).getName().replace('.', '/'));
            sb.append('<');
            for (Type p : pt.getActualTypeArguments()) {
                GenericUtils.toGenericSignature(sb, p);
            }
            sb.append(">;");
        } else if (type instanceof Class) {
            Class clazz = (Class)type;
            if (!clazz.isPrimitive() && !clazz.isArray()) {
                sb.append('L');
                sb.append(clazz.getName().replace('.', '/'));
                sb.append(';');
            } else {
                sb.append(clazz.getName().replace('.', '/'));
            }
        } else if (type instanceof WildcardType) {
            boolean hasUpper;
            WildcardType wc = (WildcardType)type;
            Type[] lowerBounds = wc.getLowerBounds();
            Type[] upperBounds = wc.getUpperBounds();
            boolean hasLower = lowerBounds != null && lowerBounds.length > 0;
            boolean bl = hasUpper = upperBounds != null && upperBounds.length > 0;
            if (hasUpper && hasLower && Object.class.equals((Object)lowerBounds[0]) && Object.class.equals((Object)upperBounds[0])) {
                sb.append('*');
            } else if (hasLower) {
                sb.append("-");
                for (Type b : lowerBounds) {
                    GenericUtils.toGenericSignature(sb, b);
                }
            } else if (hasUpper) {
                if (upperBounds.length == 1 && Object.class.equals((Object)upperBounds[0])) {
                    sb.append("*");
                } else {
                    sb.append("+");
                    for (Type b : upperBounds) {
                        GenericUtils.toGenericSignature(sb, b);
                    }
                }
            } else {
                sb.append('*');
            }
        } else if (type instanceof TypeVariable) {
            GenericUtils.toGenericSignature(sb, ((TypeVariable)type).getBounds()[0]);
        } else {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
    }
}

