/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.pipeline;

import cloud.orbit.actors.cluster.pipeline.RedisPipelineStep;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;

public class RedisCompressionPipelineStep
implements RedisPipelineStep {
    private static final int DECOMPRESSION_HEADER_SIZE = 4;
    private final LZ4Factory factory = LZ4Factory.fastestJavaInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf read(ByteBuf buf) {
        try {
            int decompressSize = buf.readInt();
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer(decompressSize);
            LZ4SafeDecompressor decompressor = this.factory.safeDecompressor();
            ByteBuffer outBuffer = out.internalNioBuffer(out.writerIndex(), out.writableBytes());
            int position = outBuffer.position();
            decompressor.decompress(buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes()), outBuffer);
            int compressedLength = outBuffer.position() - position;
            out.writerIndex(compressedLength);
            ByteBuf byteBuf = out;
            return byteBuf;
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf write(ByteBuf buf) {
        try {
            LZ4Compressor compressor = this.factory.fastCompressor();
            ByteBuffer srcBuf = buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes());
            int outMaxLength = compressor.maxCompressedLength(buf.readableBytes());
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer(outMaxLength + 4);
            out.writeInt(buf.readableBytes());
            ByteBuffer outBuf = out.internalNioBuffer(out.writerIndex(), out.writableBytes());
            int position = outBuf.position();
            compressor.compress(srcBuf, outBuf);
            int compressedLength = outBuf.position() - position;
            out.writerIndex(out.writerIndex() + compressedLength);
            ByteBuf byteBuf = out;
            return byteBuf;
        }
        finally {
            buf.release();
        }
    }
}

