/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import cloud.orbit.actors.cluster.DistributedMap;
import cloud.orbit.actors.cluster.impl.RedisOrbitClient;
import cloud.orbit.concurrent.Task;
import com.github.ssedano.hash.JumpConsistentHash;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.api.RMap;

public class RedisShardedMap<K, V>
implements DistributedMap<K, V> {
    private final Integer bucketCount;
    private final List<RedisOrbitClient> redissonClients;
    private final String mapName;
    private final ConcurrentMap<String, RMap<K, V>> cacheManager = new ConcurrentHashMap<String, RMap<K, V>>();

    public RedisShardedMap(String mapName, List<RedisOrbitClient> redissonClients, Integer bucketCount) {
        this.mapName = mapName;
        this.redissonClients = redissonClients;
        this.bucketCount = bucketCount;
    }

    private RMap<K, V> getBucketMap(Integer bucket) {
        Integer clientId;
        RMap temp;
        String realName = this.mapName + "#" + bucket;
        RMap result = (RMap)this.cacheManager.get(realName);
        if (result == null && (result = this.cacheManager.putIfAbsent(realName, temp = this.redissonClients.get(clientId = Integer.valueOf(JumpConsistentHash.jumpConsistentHash((Object)realName, (int)this.redissonClients.size()))).getRedissonClient().getMap(realName))) == null) {
            result = temp;
        }
        return result;
    }

    private RMap<K, V> getRealMap(Object key) {
        Integer bucket = JumpConsistentHash.jumpConsistentHash((Object)key, (int)this.bucketCount);
        return this.getBucketMap(bucket);
    }

    public Task<V> putIfAbsent(K k, V v) {
        return Task.from((CompletionStage)this.getRealMap(k).putIfAbsentAsync(k, v));
    }

    public Task<V> put(K k, V v) {
        return Task.from((CompletionStage)this.getRealMap(k).putAsync(k, v));
    }

    public Task<V> get(K k) {
        return Task.from((CompletionStage)this.getRealMap(k).getAsync(k));
    }

    public Task<Boolean> remove(K k, V v) {
        return Task.from((CompletionStage)this.getRealMap(k).removeAsync(k, v));
    }
}

