/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import cloud.orbit.actors.cluster.pipeline.RedisPipelineStep;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class RedisPipelineCodec
implements Codec {
    private final Codec innerCodec;
    private final List<RedisPipelineStep> pipelineSteps;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        public Object decode(ByteBuf buf, State state) throws IOException {
            ListIterator li = RedisPipelineCodec.this.pipelineSteps.listIterator(RedisPipelineCodec.this.pipelineSteps.size());
            while (li.hasPrevious()) {
                buf = ((RedisPipelineStep)li.previous()).read(buf);
            }
            return RedisPipelineCodec.this.innerCodec.getValueDecoder().decode(buf, state);
        }
    };
    private final Encoder encoder = new Encoder(){

        public ByteBuf encode(Object in) throws IOException {
            ByteBuf byteBuf = RedisPipelineCodec.this.innerCodec.getValueEncoder().encode(in);
            for (RedisPipelineStep pipelineStep : RedisPipelineCodec.this.pipelineSteps) {
                byteBuf = pipelineStep.write(byteBuf);
            }
            return byteBuf;
        }
    };

    public RedisPipelineCodec(List<RedisPipelineStep> pipelineSteps, Codec innerCodec) {
        this.innerCodec = innerCodec;
        this.pipelineSteps = pipelineSteps;
    }

    public Decoder<Object> getMapValueDecoder() {
        return this.getValueDecoder();
    }

    public Encoder getMapValueEncoder() {
        return this.getValueEncoder();
    }

    public Decoder<Object> getMapKeyDecoder() {
        return this.getValueDecoder();
    }

    public Encoder getMapKeyEncoder() {
        return this.getValueEncoder();
    }

    public ClassLoader getClassLoader() {
        return this.innerCodec.getClassLoader();
    }

    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

