/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster;

import cloud.orbit.actors.cluster.ClusterPeer;
import cloud.orbit.actors.cluster.DistributedMap;
import cloud.orbit.actors.cluster.MessageListener;
import cloud.orbit.actors.cluster.NodeAddress;
import cloud.orbit.actors.cluster.NodeAddressImpl;
import cloud.orbit.actors.cluster.RedisClusterConfig;
import cloud.orbit.actors.cluster.ViewListener;
import cloud.orbit.actors.cluster.impl.RedisConnectionManager;
import cloud.orbit.actors.cluster.impl.RedisKeyGenerator;
import cloud.orbit.actors.cluster.impl.RedisMsg;
import cloud.orbit.actors.cluster.impl.RedisOrbitClient;
import cloud.orbit.actors.cluster.impl.RedisShardedMap;
import cloud.orbit.concurrent.Task;
import cloud.orbit.tuples.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisClusterPeer
implements ClusterPeer {
    private static Logger logger = LoggerFactory.getLogger(RedisClusterPeer.class);
    private ViewListener viewListener;
    private MessageListener messageListener;
    private NodeAddress localAddress = new NodeAddressImpl(UUID.randomUUID());
    private String clusterName;
    private RedisClusterConfig config;
    private RedisConnectionManager redisConnectionManager;
    private final ConcurrentMap<String, DistributedMap<?, ?>> cacheManager = new ConcurrentHashMap();

    public RedisClusterPeer(RedisClusterConfig config) {
        this.config = config;
    }

    public <K, V> DistributedMap<K, V> getCache(String name) {
        String realName = RedisKeyGenerator.key("shardedMap", Pair.of((Object)"cluster", (Object)this.clusterName), Pair.of((Object)"mapName", (Object)name));
        DistributedMap result = (DistributedMap)this.cacheManager.get(realName);
        if (result == null) {
            result = this.cacheManager.computeIfAbsent(realName, s -> new RedisShardedMap((String)s, this.redisConnectionManager.getActorDirectoryClients(), this.config.getShardingBuckets()));
        }
        return result;
    }

    public NodeAddress localAddress() {
        return this.localAddress;
    }

    public Task<?> join(String clusterName, String nodeName) {
        logger.info("Joining Redis Cluster '{}' as node '{}' [{}]...", new Object[]{clusterName, nodeName, this.localAddress.asUUID().toString()});
        this.clusterName = clusterName;
        this.redisConnectionManager = new RedisConnectionManager(this.config);
        String nodeKey = RedisKeyGenerator.nodeKey(clusterName, this.localAddress.toString());
        this.redisConnectionManager.subscribeToChannel(nodeKey, (org.redisson.api.listener.MessageListener<RedisMsg>)((org.redisson.api.listener.MessageListener)(channel, msg) -> this.receiveMessage((RedisMsg)msg)));
        this.writeMyEntry();
        this.syncNodes();
        return Task.done();
    }

    private void writeMyEntry() {
        String nodeKey = RedisKeyGenerator.nodeKey(this.clusterName, this.localAddress.toString());
        this.redisConnectionManager.getShardedNodeDirectoryClient(nodeKey).getRedissonClient().getBucket(nodeKey).set((Object)this.localAddress.toString(), (long)this.config.getNodeLifetimeSeconds().intValue(), TimeUnit.SECONDS);
    }

    private void syncNodes() {
        String nodeKey = RedisKeyGenerator.nodeKey(this.clusterName, "*");
        ArrayList keys = new ArrayList();
        List<RedisOrbitClient> clients = this.redisConnectionManager.getNodeDirectoryClients();
        for (RedisOrbitClient client : clients) {
            keys.addAll(client.getRedissonClient().getKeys().findKeysByPattern(nodeKey));
        }
        ArrayList<NodeAddressImpl> nodeAddresses = new ArrayList<NodeAddressImpl>();
        for (String key : keys) {
            String rawKey = (String)this.redisConnectionManager.getShardedNodeDirectoryClient(key).getRedissonClient().getBucket(key).get();
            if (rawKey != null) {
                try {
                    nodeAddresses.add(new NodeAddressImpl(UUID.fromString(rawKey)));
                }
                catch (IllegalArgumentException e) {
                    logger.error("Error getting node address for {}", (Object)key, (Object)e);
                }
                continue;
            }
            logger.error("Null bucket raw key for {}", (Object)key);
        }
        this.viewListener.onViewChange(nodeAddresses);
    }

    public void sendMessage(NodeAddress toAddress, byte[] message) {
        RedisMsg redisMsg = new RedisMsg();
        redisMsg.setMessageContents(message);
        redisMsg.setSenderAddress(this.localAddress.asUUID());
        String targetNodeKey = RedisKeyGenerator.nodeKey(this.clusterName, toAddress.toString());
        this.redisConnectionManager.sendMessageToChannel(targetNodeKey, redisMsg);
    }

    public void receiveMessage(RedisMsg rawMessage) {
        Task.runAsync(() -> {
            NodeAddressImpl nodeAddr = new NodeAddressImpl(rawMessage.getSenderAddress());
            this.messageListener.receive((NodeAddress)nodeAddr, rawMessage.getMessageContents());
        }, (Executor)this.config.getCoreExecutorService()).exceptionally(e -> {
            logger.error("Error receiving message", e);
            return null;
        });
    }

    public Task pulse() {
        this.writeMyEntry();
        this.syncNodes();
        return Task.done();
    }

    public void leave() {
        String nodeKey = RedisKeyGenerator.nodeKey(this.clusterName, this.localAddress.toString());
        this.redisConnectionManager.getShardedNodeDirectoryClient(nodeKey).getRedissonClient().getBucket(nodeKey).delete();
        this.redisConnectionManager.shutdownConnections();
    }

    public void registerMessageReceiver(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void registerViewListener(ViewListener viewListener) {
        this.viewListener = viewListener;
    }
}

