/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster;

import cloud.orbit.actors.cluster.RedisClusterConfig;
import cloud.orbit.actors.cluster.RedisClusterPeer;
import cloud.orbit.actors.cluster.pipeline.RedisPipelineStep;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class RedisClusterBuilder {
    private RedisClusterConfig redisClusterConfig = new RedisClusterConfig();

    public RedisClusterBuilder nodeDirectoryUri(String nodeDirectoryUri) {
        this.redisClusterConfig.setNodeDirectoryUris(Arrays.asList(nodeDirectoryUri));
        return this;
    }

    public RedisClusterBuilder nodeDirectoryUris(List<String> nodeDirectoryUris) {
        this.redisClusterConfig.setNodeDirectoryUris(nodeDirectoryUris);
        return this;
    }

    public RedisClusterBuilder actorDirectoryUri(String actorDirectoryUri) {
        this.redisClusterConfig.setActorDirectoryUris(Arrays.asList(actorDirectoryUri));
        return this;
    }

    public RedisClusterBuilder actorDirectoryUris(List<String> actorDirectoryUris) {
        this.redisClusterConfig.setActorDirectoryUris(actorDirectoryUris);
        return this;
    }

    public RedisClusterBuilder messagingUri(String messagingUri) {
        this.redisClusterConfig.setMessagingUris(Arrays.asList(messagingUri));
        return this;
    }

    public RedisClusterBuilder messagingUris(List<String> messagingUris) {
        this.redisClusterConfig.setMessagingUris(messagingUris);
        return this;
    }

    public RedisClusterBuilder nodeLifetimeSecs(Integer nodeLifetimeSecs) {
        this.redisClusterConfig.setNodeLifetimeSeconds(nodeLifetimeSecs);
        return this;
    }

    public RedisClusterBuilder minRedisConnections(Integer minRedisConnections) {
        this.redisClusterConfig.setMinRedisConnections(minRedisConnections);
        return this;
    }

    public RedisClusterBuilder maxRedisConnections(Integer maxRedisConnections) {
        this.redisClusterConfig.setMaxRedisConnections(maxRedisConnections);
        return this;
    }

    public RedisClusterBuilder connectionTimeout(Integer connectionTimeout) {
        this.redisClusterConfig.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public RedisClusterBuilder generalTimeout(Integer generalTimeout) {
        this.redisClusterConfig.setGeneralTimeout(generalTimeout);
        return this;
    }

    public RedisClusterBuilder idleTimeout(Integer idleTimeout) {
        this.redisClusterConfig.setIdleTimeout(idleTimeout);
        return this;
    }

    public RedisClusterBuilder reconnectionTimeout(Integer reconnectionTimeout) {
        this.redisClusterConfig.setReconnectionTimeout(reconnectionTimeout);
        return this;
    }

    public RedisClusterBuilder pingTimeout(Integer pingTimeout) {
        this.redisClusterConfig.setPingTimeout(pingTimeout);
        return this;
    }

    public RedisClusterBuilder retryAttempts(Integer retryAttempts) {
        this.redisClusterConfig.setRetryAttempts(retryAttempts);
        return this;
    }

    public RedisClusterBuilder failedAttempts(Integer failedAttempts) {
        this.redisClusterConfig.setRetryAttempts(failedAttempts);
        return this;
    }

    public RedisClusterBuilder messageSendAttempts(Integer messageSendAttempts) {
        this.redisClusterConfig.setMessageSendAttempts(messageSendAttempts);
        return this;
    }

    public RedisClusterBuilder retryInterval(Integer retryInterval) {
        this.redisClusterConfig.setRetryInterval(retryInterval);
        return this;
    }

    public RedisClusterBuilder dnsMonitoring(Boolean dnsMonitoring) {
        this.redisClusterConfig.setDnsMonitoring(dnsMonitoring);
        return this;
    }

    public RedisClusterBuilder dnsMonitoringInterval(Integer dnsMonitoringInterval) {
        this.redisClusterConfig.setDnsMonitoringInverval(dnsMonitoringInterval);
        return this;
    }

    public RedisClusterBuilder messagingHealthcheckInterval(Integer messagingHealthcheckInterval) {
        this.redisClusterConfig.setMessagingHealthcheckInterval(messagingHealthcheckInterval);
        return this;
    }

    public RedisClusterBuilder shardingBuckets(Integer shardingBuckets) {
        this.redisClusterConfig.setShardingBuckets(shardingBuckets);
        return this;
    }

    public RedisClusterBuilder redissonThreads(Integer redissonThreads) {
        this.redisClusterConfig.setRedissonThreads(redissonThreads);
        return this;
    }

    public RedisClusterBuilder nettyThreads(Integer nettyThreads) {
        this.redisClusterConfig.setNettyThreads(nettyThreads);
        return this;
    }

    public RedisClusterBuilder shareEventLoop(Boolean shareEventLoop) {
        this.redisClusterConfig.setShareEventLoop(shareEventLoop);
        return this;
    }

    public RedisClusterBuilder redissonExecutorService(ExecutorService redissonExecutorService) {
        this.redisClusterConfig.setRedissonExecutorService(redissonExecutorService);
        return this;
    }

    public RedisClusterBuilder pipelineSteps(List<RedisPipelineStep> pipelineSteps) {
        this.redisClusterConfig.setPipelineSteps(pipelineSteps);
        return this;
    }

    public RedisClusterBuilder pipelineSteps(RedisPipelineStep ... pipelineSteps) {
        this.redisClusterConfig.setPipelineSteps(Arrays.asList(pipelineSteps));
        return this;
    }

    public RedisClusterBuilder coreExecutorService(ExecutorService coreExecutorService) {
        this.redisClusterConfig.setCoreExecutorService(coreExecutorService);
        return this;
    }

    public RedisClusterPeer build() {
        return new RedisClusterPeer(this.redisClusterConfig);
    }
}

