/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import cloud.orbit.tuples.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisOrbitClient {
    private static Logger logger = LoggerFactory.getLogger(RedisOrbitClient.class);
    private final RedissonClient redisClient;
    private volatile boolean isConnected = false;
    private final List<Pair<String, MessageListener<Object>>> subscriptions = new ArrayList<Pair<String, MessageListener<Object>>>();
    private final Timer connectionTimer;

    public RedisOrbitClient(RedissonClient redisClient, Integer messagingHealthcheckInterval) {
        this.redisClient = redisClient;
        this.isConnected = redisClient.getNodesGroup().pingAll();
        this.connectionTimer = new Timer();
        this.connectionTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                RedisOrbitClient.this.connectionTask();
            }
        }, 0L, (long)messagingHealthcheckInterval.intValue());
        this.connectionTask();
    }

    public void subscribe(String channelId, MessageListener<Object> messageListener) {
        this.subscriptions.add((Pair<String, MessageListener<Object>>)Pair.of((Object)channelId, messageListener));
        if (this.isConnected) {
            this.redisClient.getTopic(channelId).addListener(messageListener);
        }
    }

    private void connectionTask() {
        try {
            boolean nowConnected = false;
            try {
                nowConnected = this.redisClient.getNodesGroup().pingAll();
            }
            catch (Throwable e) {
                logger.error("Unexpected error during redis ping", e);
            }
            if (!nowConnected) {
                this.isConnected = false;
                logger.error("Redis is not connected: {}", (Object)this.redisClient.getNodesGroup().getNodes().stream().map(x -> x.getAddr().toString()).collect(Collectors.joining(",")));
            }
            if (nowConnected && !this.isConnected) {
                boolean subscribedAll = true;
                for (Pair<String, MessageListener<Object>> subscription : this.subscriptions) {
                    try {
                        this.redisClient.getTopic((String)subscription.getLeft()).removeAllListeners();
                        this.redisClient.getTopic((String)subscription.getLeft()).addListener((MessageListener)subscription.getRight());
                    }
                    catch (Exception e) {
                        logger.warn("Could not resubscribe to '{}'", subscription.getLeft(), (Object)e);
                        subscribedAll = false;
                        break;
                    }
                }
                this.isConnected = subscribedAll;
            }
        }
        catch (Throwable e) {
            logger.error("Unexpected connection task error", e);
        }
    }

    public boolean isConnectied() {
        return this.isConnected;
    }

    public RedissonClient getRedissonClient() {
        return this.redisClient;
    }

    public void shutdown() {
        this.connectionTimer.cancel();
        this.redisClient.shutdown();
    }
}

