/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import cloud.orbit.tuples.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;

public class RedisOrbitClient {
    private final RedissonClient redisClient;
    private final Integer messagingHealthcheckInterval;
    private boolean isConnected = false;
    private final List<Pair<String, MessageListener<Object>>> subscriptions = new ArrayList<Pair<String, MessageListener<Object>>>();
    private Timer connectionTimer;

    public RedisOrbitClient(RedissonClient redisClient, Integer messagingHealthcheckInterval) {
        this.messagingHealthcheckInterval = messagingHealthcheckInterval;
        this.redisClient = redisClient;
        this.isConnected = redisClient.getNodesGroup().pingAll();
        this.connectionTimer = new Timer();
        this.connectionTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                RedisOrbitClient.this.connectionTask();
            }
        }, 0L, (long)messagingHealthcheckInterval.intValue());
        this.connectionTask();
    }

    public void subscribe(String channelId, MessageListener<Object> messageListener) {
        this.subscriptions.add((Pair<String, MessageListener<Object>>)Pair.of((Object)channelId, messageListener));
        if (this.isConnected) {
            this.redisClient.getTopic(channelId).addListener(messageListener);
        }
    }

    private void connectionTask() {
        boolean nowConnected = this.redisClient.getNodesGroup().pingAll();
        if (!nowConnected) {
            this.isConnected = false;
        }
        if (nowConnected && !this.isConnected) {
            boolean subscribedAll = true;
            for (Pair<String, MessageListener<Object>> subscription : this.subscriptions) {
                try {
                    this.redisClient.getTopic((String)subscription.getLeft()).removeAllListeners();
                    this.redisClient.getTopic((String)subscription.getLeft()).addListener((MessageListener)subscription.getRight());
                }
                catch (Exception e) {
                    subscribedAll = false;
                    break;
                }
            }
            this.isConnected = subscribedAll;
        }
    }

    public boolean isConnectied() {
        return this.isConnected;
    }

    public RedissonClient getRedissonClient() {
        return this.redisClient;
    }

    public void shutdown() {
        this.connectionTimer.cancel();
        this.redisClient.shutdown();
    }
}

