/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import java.net.InetSocketAddress;
import org.redisson.api.RedissonClient;
import org.redisson.connection.ConnectionListener;

public class RedisOrbitClient {
    private final RedissonClient redisClient;
    private boolean isConnected = false;

    public RedisOrbitClient(RedissonClient redisClient) {
        this.redisClient = redisClient;
        this.isConnected = redisClient.getNodesGroup().pingAll();
        this.redisClient.getNodesGroup().addConnectionListener(new ConnectionListener(){

            public void onConnect(InetSocketAddress inetSocketAddress) {
                RedisOrbitClient.this.isConnected = true;
            }

            public void onDisconnect(InetSocketAddress inetSocketAddress) {
                RedisOrbitClient.this.isConnected = false;
            }
        });
    }

    public boolean isConnectied() {
        return this.isConnected;
    }

    public RedissonClient getRedissonClient() {
        return this.redisClient;
    }

    public void shutdown() {
        this.redisClient.shutdown();
    }
}

