/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import cloud.orbit.tuples.Pair;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.redisson.connection.ConnectionListener;

public class RedisOrbitClient {
    private Timer timer = new Timer();
    private final RedissonClient redisClient;
    private boolean isConnected = false;
    private final List<Pair<String, MessageListener<Object>>> subscriptions = new ArrayList<Pair<String, MessageListener<Object>>>();

    public RedisOrbitClient(RedissonClient redisClient) {
        this.redisClient = redisClient;
        this.redisClient.getNodesGroup().addConnectionListener(new ConnectionListener(){

            public void onConnect(InetSocketAddress inetSocketAddress) {
                RedisOrbitClient.this.onConnectionEvent(true);
            }

            public void onDisconnect(InetSocketAddress inetSocketAddress) {
                RedisOrbitClient.this.onConnectionEvent(false);
            }
        });
        this.isConnected = redisClient.getNodesGroup().pingAll();
    }

    public void subscribe(String channelId, MessageListener<Object> messageListener) {
        this.subscriptions.add((Pair<String, MessageListener<Object>>)Pair.of((Object)channelId, messageListener));
        if (this.isConnected) {
            this.redisClient.getTopic(channelId).addListener(messageListener);
        }
    }

    private void onConnectionEvent(boolean nowConnected) {
        if (nowConnected && !this.isConnected) {
            this.subscriptions.forEach(sub -> {
                boolean subscribed = false;
                while (!subscribed) {
                    try {
                        this.redisClient.getTopic((String)sub.getLeft()).removeAllListeners();
                        this.redisClient.getTopic((String)sub.getLeft()).addListener((MessageListener)sub.getRight());
                        subscribed = true;
                    }
                    catch (Exception exception) {}
                }
            });
        }
        this.isConnected = nowConnected;
    }

    public boolean isConnectied() {
        return this.isConnected;
    }

    public RedissonClient getRedissonClient() {
        return this.redisClient;
    }

    public void shutdown() {
        this.redisClient.shutdown();
    }
}

