/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.pipeline;

import cloud.orbit.actors.cluster.pipeline.RedisPipelineStep;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;

public class RedisCompressionPipelineStep
implements RedisPipelineStep {
    private final LZ4Factory factory = LZ4Factory.fastestJavaInstance();

    @Override
    public byte[] read(byte[] buf) {
        Integer rawLength = buf.length;
        Integer compressedLength = rawLength - 4;
        ByteBuffer byteBuf = ByteBuffer.allocate(buf.length);
        byteBuf.put(buf);
        byteBuf.rewind();
        Integer decompressedLength = byteBuf.getInt();
        byte[] decompressedBytes = new byte[decompressedLength.intValue()];
        byte[] compressedBytes = new byte[compressedLength.intValue()];
        byteBuf.get(compressedBytes);
        LZ4SafeDecompressor decompressor = this.factory.safeDecompressor();
        decompressor.decompress(compressedBytes, decompressedBytes);
        return decompressedBytes;
    }

    @Override
    public byte[] write(byte[] uncompressedBytes) {
        LZ4Compressor compressor = this.factory.fastCompressor();
        byte[] compressedBytes = compressor.compress(uncompressedBytes);
        ByteBuffer buffer = ByteBuffer.allocate(compressedBytes.length + 4);
        buffer.putInt(uncompressedBytes.length);
        buffer.put(compressedBytes);
        return buffer.array();
    }
}

