/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import cloud.orbit.tuples.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;

public class RedisOrbitClient {
    private Timer timer = new Timer();
    private final RedissonClient redisClient;
    private boolean isConnected = false;
    private final List<Pair<String, MessageListener<Object>>> subscriptions = new ArrayList<Pair<String, MessageListener<Object>>>();

    public RedisOrbitClient(RedissonClient redisClient) {
        this.redisClient = redisClient;
        this.onTimer();
    }

    public void subscribe(String channelId, MessageListener<Object> messageListener) {
        this.subscriptions.add((Pair<String, MessageListener<Object>>)Pair.of((Object)channelId, messageListener));
        if (this.isConnected) {
            this.redisClient.getTopic(channelId).addListener(messageListener);
        }
    }

    private void onTimer() {
        Boolean nowConnected = this.redisClient.getNodesGroup().pingAll();
        if (nowConnected.booleanValue() && !this.isConnected) {
            this.subscriptions.forEach(sub -> {
                this.redisClient.getTopic((String)sub.getLeft()).removeAllListeners();
                this.redisClient.getTopic((String)sub.getLeft()).addListener((MessageListener)sub.getRight());
            });
        }
        this.isConnected = nowConnected;
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                RedisOrbitClient.this.onTimer();
            }
        }, 10000L);
    }

    public boolean isConnectied() {
        return this.isConnected;
    }

    public RedissonClient getRedissonClient() {
        return this.redisClient;
    }

    public void shutdown() {
        this.redisClient.shutdown();
    }
}

