/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import cloud.orbit.actors.cluster.RedisClusterConfig;
import cloud.orbit.actors.cluster.impl.RedisPipelineCodec;
import cloud.orbit.exception.UncheckedException;
import com.github.ssedano.hash.JumpConsistentHash;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.codec.SerializationCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisDB {
    private RedisClusterConfig redisClusterConfig = null;
    private List<RedissonClient> nodeDirectoryClients = new ArrayList<RedissonClient>();
    private List<RedissonClient> actorDirectoryClients = new ArrayList<RedissonClient>();
    private List<RedissonClient> messagingClients = new ArrayList<RedissonClient>();
    private EventLoopGroup eventLoopGroup = null;
    private static Logger logger = LoggerFactory.getLogger(RedisDB.class);

    public RedisDB(RedisClusterConfig redisClusterConfig) {
        this.redisClusterConfig = redisClusterConfig;
        if (redisClusterConfig.getShareEventLoop().booleanValue()) {
            this.eventLoopGroup = new NioEventLoopGroup();
        }
        List<String> nodeDirectoryMasters = redisClusterConfig.getNodeDirectoryUris();
        for (String string : nodeDirectoryMasters) {
            logger.info("Connecting to Redis Node Directory node at '{}'...", (Object)string);
            this.nodeDirectoryClients.add(this.createClient(string, true));
        }
        List<String> actorDirectoryMasters = redisClusterConfig.getActorDirectoryUris();
        for (String uri : actorDirectoryMasters) {
            logger.info("Connecting to Redis Actor Directory node at '{}'...", (Object)uri);
            this.actorDirectoryClients.add(this.createClient(uri, true));
        }
        List<String> list = redisClusterConfig.getMessagingUris();
        for (String uri : list) {
            logger.info("Connecting to Redis messaging node at '{}'...", (Object)uri);
            this.messagingClients.add(this.createClient(uri, false));
        }
    }

    public List<RedissonClient> getNodeDirectoryClients() {
        return Collections.unmodifiableList(this.nodeDirectoryClients);
    }

    public List<RedissonClient> getActorDirectoryClients() {
        return Collections.unmodifiableList(this.actorDirectoryClients);
    }

    public List<RedissonClient> getMessagingClients() {
        return Collections.unmodifiableList(this.messagingClients);
    }

    public RedissonClient getShardedNodeDirectoryClient(String shardId) {
        int jumpConsistentHash = JumpConsistentHash.jumpConsistentHash((Object)shardId, (int)this.nodeDirectoryClients.size());
        return this.nodeDirectoryClients.get(jumpConsistentHash);
    }

    public RedissonClient getShardedActorDirectoryClient(String shardId) {
        int jumpConsistentHash = JumpConsistentHash.jumpConsistentHash((Object)shardId, (int)this.actorDirectoryClients.size());
        return this.actorDirectoryClients.get(jumpConsistentHash);
    }

    public void subscribeToChannel(String channelId, MessageListener<Object> statusListener) {
        for (RedissonClient messagingClient : this.messagingClients) {
            messagingClient.getTopic(channelId).addListener(statusListener);
        }
    }

    public void sendMessageToChannel(String channelId, Object msg) {
        List<RedissonClient> localMessagingClients = this.messagingClients;
        int activeClientCount = localMessagingClients.size();
        if (activeClientCount <= 0) {
            throw new UncheckedException("No Redis messaging instances available.");
        }
        int randomId = ThreadLocalRandom.current().nextInt(activeClientCount);
        RedissonClient client = localMessagingClients.get(randomId);
        client.getTopic(channelId).publishAsync(msg).exceptionally(e -> {
            logger.error("Error sending message", e);
            return 0L;
        });
    }

    public void shutdownConnections() {
        this.nodeDirectoryClients.forEach(RedissonClient::shutdown);
        this.actorDirectoryClients.forEach(RedissonClient::shutdown);
        this.messagingClients.forEach(RedissonClient::shutdown);
    }

    private RedissonClient createClient(String uri, Boolean useJavaSerializer) {
        Integer port;
        URI realUri = URI.create(uri);
        if (!realUri.getScheme().equalsIgnoreCase("redis")) {
            throw new UncheckedException("Invalid Redis URI.");
        }
        String host = realUri.getHost();
        if (host == null) {
            host = "localhost";
        }
        if ((port = Integer.valueOf(realUri.getPort())) == -1) {
            port = 6379;
        }
        String resolvedUri = "redis://" + host + ":" + port;
        Config redissonConfig = new Config();
        Object currentCodec = useJavaSerializer != false ? new SerializationCodec() : new JsonJacksonCodec();
        currentCodec = new RedisPipelineCodec(this.redisClusterConfig.getPipelineSteps(), (Codec)currentCodec);
        redissonConfig.setCodec((Codec)currentCodec);
        if (this.eventLoopGroup != null) {
            redissonConfig.setEventLoopGroup(this.eventLoopGroup);
        }
        redissonConfig.setThreads(this.redisClusterConfig.getRedissonThreads().intValue());
        redissonConfig.setNettyThreads(this.redisClusterConfig.getNettyThreads().intValue());
        if (this.redisClusterConfig.getRedissonExecutorService() != null) {
            redissonConfig.setExecutor(this.redisClusterConfig.getRedissonExecutorService());
        }
        ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)redissonConfig.useSingleServer().setDnsMonitoring(true).setAddress(resolvedUri).setConnectionMinimumIdleSize(this.redisClusterConfig.getMinRedisConnections().intValue()).setConnectionPoolSize(this.redisClusterConfig.getMaxRedisConnections().intValue()).setConnectTimeout(this.redisClusterConfig.getConnectionTimeout().intValue())).setTimeout(this.redisClusterConfig.getGeneralTimeout().intValue())).setIdleConnectionTimeout(this.redisClusterConfig.getIdleTimeout().intValue())).setReconnectionTimeout(this.redisClusterConfig.getReconnectionTimeout().intValue())).setPingTimeout(this.redisClusterConfig.getPingTimeout().intValue())).setRetryAttempts(this.redisClusterConfig.getRetryAttempts().intValue())).setRetryInterval(this.redisClusterConfig.getRetryInterval().intValue());
        return Redisson.create((Config)redissonConfig);
    }
}

