/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster;

import cloud.orbit.actors.cluster.pipeline.RedisBasicPipeline;
import cloud.orbit.actors.cluster.pipeline.RedisPipelineStep;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;

public class RedisClusterConfig {
    private List<String> actorDirectoryUris = Arrays.asList("redis://localhost");
    private Boolean actorDirectoryClustered = false;
    private List<String> nodeDirectoryUris = Arrays.asList("redis://localhost");
    private Boolean nodeDirectoryClustered = false;
    private List<String> messagingUris = Arrays.asList("redis://localhost");
    private Boolean messagingClustered = false;
    private Integer nodeLifetimeSeconds = 20;
    private Integer minRedisConnections = 10;
    private Integer maxRedisConnections = 64;
    private Integer connectionTimeout = 10000;
    private Integer generalTimeout = 20000;
    private Integer idleTimeout = 10000;
    private Integer reconnectionTimeout = 10000;
    private Integer pingTimeout = 10000;
    private Integer retryAttempts = Integer.MAX_VALUE;
    private Integer retryInterval = 10000;
    private Integer shardingBuckets = 256;
    private Integer redissonThreads = Runtime.getRuntime().availableProcessors() * 2;
    private Integer nettyThreads = Runtime.getRuntime().availableProcessors() * 2;
    private ExecutorService redissonExecutorService = null;
    private Boolean shareEventLoop = false;
    private List<RedisPipelineStep> pipelineSteps = RedisBasicPipeline.defaultPipeline();
    private ExecutorService coreExecutorService = ForkJoinPool.commonPool();

    public List<String> getActorDirectoryUris() {
        return this.actorDirectoryUris;
    }

    public void setActorDirectoryUris(List<String> actorDirectoryUris) {
        this.actorDirectoryUris = Collections.unmodifiableList(actorDirectoryUris);
    }

    public List<String> getNodeDirectoryUris() {
        return this.nodeDirectoryUris;
    }

    public void setNodeDirectoryUris(List<String> nodeDirectoryUris) {
        this.nodeDirectoryUris = Collections.unmodifiableList(nodeDirectoryUris);
    }

    public List<String> getMessagingUris() {
        return this.messagingUris;
    }

    public void setMessagingUris(List<String> messagingUris) {
        this.messagingUris = Collections.unmodifiableList(messagingUris);
    }

    public Boolean getMessagingClustered() {
        return this.messagingClustered;
    }

    public void setMessagingClustered(Boolean messagingClustered) {
        this.messagingClustered = messagingClustered;
    }

    public Boolean getActorDirectoryClustered() {
        return this.actorDirectoryClustered;
    }

    public void setActorDirectoryClustered(Boolean actorDirectoryClustered) {
        this.actorDirectoryClustered = actorDirectoryClustered;
    }

    public Boolean getNodeDirectoryClustered() {
        return this.nodeDirectoryClustered;
    }

    public void setNodeDirectoryClustered(Boolean nodeDirectoryClustered) {
        this.nodeDirectoryClustered = nodeDirectoryClustered;
    }

    public Integer getNodeLifetimeSeconds() {
        return this.nodeLifetimeSeconds;
    }

    public void setNodeLifetimeSeconds(Integer nodeLifetimeSeconds) {
        this.nodeLifetimeSeconds = nodeLifetimeSeconds;
    }

    public Integer getMinRedisConnections() {
        return this.minRedisConnections;
    }

    public void setMinRedisConnections(Integer minRedisConnections) {
        this.minRedisConnections = minRedisConnections;
    }

    public Integer getMaxRedisConnections() {
        return this.maxRedisConnections;
    }

    public void setMaxRedisConnections(Integer maxRedisConnections) {
        this.maxRedisConnections = maxRedisConnections;
    }

    public ExecutorService getCoreExecutorService() {
        return this.coreExecutorService;
    }

    public void setCoreExecutorService(ExecutorService coreExecutorService) {
        this.coreExecutorService = coreExecutorService;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getGeneralTimeout() {
        return this.generalTimeout;
    }

    public void setGeneralTimeout(Integer generalTimeout) {
        this.generalTimeout = generalTimeout;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Integer getReconnectionTimeout() {
        return this.reconnectionTimeout;
    }

    public void setReconnectionTimeout(Integer reconnectionTimeout) {
        this.reconnectionTimeout = reconnectionTimeout;
    }

    public Integer getPingTimeout() {
        return this.pingTimeout;
    }

    public void setPingTimeout(Integer pingTimeout) {
        this.pingTimeout = pingTimeout;
    }

    public Integer getRetryAttempts() {
        return this.retryAttempts;
    }

    public void setRetryAttempts(Integer retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Integer getShardingBuckets() {
        return this.shardingBuckets;
    }

    public void setShardingBuckets(Integer shardingBuckets) {
        this.shardingBuckets = shardingBuckets;
    }

    public List<RedisPipelineStep> getPipelineSteps() {
        return this.pipelineSteps;
    }

    public void setPipelineSteps(List<RedisPipelineStep> pipelineSteps) {
        this.pipelineSteps = Collections.unmodifiableList(pipelineSteps);
    }

    public Integer getRedissonThreads() {
        return this.redissonThreads;
    }

    public void setRedissonThreads(Integer redissonThreads) {
        this.redissonThreads = redissonThreads;
    }

    public Integer getNettyThreads() {
        return this.nettyThreads;
    }

    public void setNettyThreads(Integer nettyThreads) {
        this.nettyThreads = nettyThreads;
    }

    public Boolean getShareEventLoop() {
        return this.shareEventLoop;
    }

    public void setShareEventLoop(Boolean shareEventLoop) {
        this.shareEventLoop = shareEventLoop;
    }

    public ExecutorService getRedissonExecutorService() {
        return this.redissonExecutorService;
    }

    public void setRedissonExecutorService(ExecutorService redissonExecutorService) {
        this.redissonExecutorService = redissonExecutorService;
    }
}

