/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster;

import cloud.orbit.actors.cluster.RedisClusterConfig;
import cloud.orbit.actors.cluster.RedisClusterPeer;
import cloud.orbit.actors.cluster.pipeline.RedisPipelineStep;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class RedisClusterBuilder {
    private RedisClusterConfig redisClusterConfig = new RedisClusterConfig();

    public RedisClusterBuilder nodeDirectoryUri(String nodeDirectoryUri) {
        return this.nodeDirectoryUri(nodeDirectoryUri, false);
    }

    public RedisClusterBuilder nodeDirectoryUri(String nodeDirectoryUri, Boolean redisClustering) {
        this.redisClusterConfig.setNodeDirectoryUris(Arrays.asList(nodeDirectoryUri));
        this.redisClusterConfig.setNodeDirectoryClustered(redisClustering);
        return this;
    }

    public RedisClusterBuilder nodeDirectoryUris(List<String> nodeDirectoryUris) {
        return this.nodeDirectoryUris(nodeDirectoryUris, false);
    }

    public RedisClusterBuilder nodeDirectoryUris(List<String> nodeDirectoryUris, Boolean redisClustering) {
        this.redisClusterConfig.setNodeDirectoryUris(nodeDirectoryUris);
        this.redisClusterConfig.setNodeDirectoryClustered(redisClustering);
        return this;
    }

    public RedisClusterBuilder actorDirectoryUri(String actorDirectoryUri) {
        return this.actorDirectoryUri(actorDirectoryUri, false);
    }

    public RedisClusterBuilder actorDirectoryUri(String actorDirectoryUri, Boolean redisClustering) {
        this.redisClusterConfig.setActorDirectoryUris(Arrays.asList(actorDirectoryUri));
        this.redisClusterConfig.setActorDirectoryClustered(redisClustering);
        return this;
    }

    public RedisClusterBuilder actorDirectoryUris(List<String> actorDirectoryUris) {
        return this.actorDirectoryUris(actorDirectoryUris, false);
    }

    public RedisClusterBuilder actorDirectoryUris(List<String> actorDirectoryUris, Boolean redisClustering) {
        this.redisClusterConfig.setActorDirectoryUris(actorDirectoryUris);
        this.redisClusterConfig.setActorDirectoryClustered(redisClustering);
        return this;
    }

    public RedisClusterBuilder messagingUri(String messagingUri) {
        return this.messagingUri(messagingUri, false);
    }

    public RedisClusterBuilder messagingUri(String messagingUri, Boolean redisClustering) {
        this.redisClusterConfig.setMessagingUris(Arrays.asList(messagingUri));
        this.redisClusterConfig.setMessagingClustered(redisClustering);
        return this;
    }

    public RedisClusterBuilder messagingUris(List<String> messagingUris) {
        return this.messagingUris(messagingUris, false);
    }

    public RedisClusterBuilder messagingUris(List<String> messagingUris, Boolean redisClustering) {
        this.redisClusterConfig.setMessagingUris(messagingUris);
        this.redisClusterConfig.setMessagingClustered(redisClustering);
        return this;
    }

    public RedisClusterBuilder nodeLifetimeSecs(Integer nodeLifetimeSecs) {
        this.redisClusterConfig.setNodeLifetimeSeconds(nodeLifetimeSecs);
        return this;
    }

    public RedisClusterBuilder minRedisConnections(Integer minRedisConnections) {
        this.redisClusterConfig.setMinRedisConnections(minRedisConnections);
        return this;
    }

    public RedisClusterBuilder maxRedisConnections(Integer maxRedisConnections) {
        this.redisClusterConfig.setMaxRedisConnections(maxRedisConnections);
        return this;
    }

    public RedisClusterBuilder connectionTimeout(Integer connectionTimeout) {
        this.redisClusterConfig.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public RedisClusterBuilder generalTimeout(Integer generalTimeout) {
        this.redisClusterConfig.setGeneralTimeout(generalTimeout);
        return this;
    }

    public RedisClusterBuilder idleTimeout(Integer idleTimeout) {
        this.redisClusterConfig.setIdleTimeout(idleTimeout);
        return this;
    }

    public RedisClusterBuilder reconnectionTimeout(Integer reconnectionTimeout) {
        this.redisClusterConfig.setReconnectionTimeout(reconnectionTimeout);
        return this;
    }

    public RedisClusterBuilder pingTimeout(Integer pingTimeout) {
        this.redisClusterConfig.setPingTimeout(pingTimeout);
        return this;
    }

    public RedisClusterBuilder retryAttempts(Integer retryAttempts) {
        this.redisClusterConfig.setRetryAttempts(retryAttempts);
        return this;
    }

    public RedisClusterBuilder retryInterval(Integer retryInterval) {
        this.redisClusterConfig.setRetryInterval(retryInterval);
        return this;
    }

    public RedisClusterBuilder shardingBuckets(Integer shardingBuckets) {
        this.redisClusterConfig.setShardingBuckets(shardingBuckets);
        return this;
    }

    public RedisClusterBuilder pipelineSteps(List<RedisPipelineStep> pipelineSteps) {
        this.redisClusterConfig.setPipelineSteps(pipelineSteps);
        return this;
    }

    public RedisClusterBuilder pipelineSteps(RedisPipelineStep ... pipelineSteps) {
        this.redisClusterConfig.setPipelineSteps(Arrays.asList(pipelineSteps));
        return this;
    }

    public RedisClusterBuilder executorService(ExecutorService executorService) {
        this.redisClusterConfig.setExecutorService(executorService);
        return this;
    }

    public RedisClusterPeer build() {
        return new RedisClusterPeer(this.redisClusterConfig);
    }
}

