/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import cloud.orbit.exception.UncheckedException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class RedisEncryptionCodec
implements Codec {
    private final Codec innerCodec;
    private final SecretKey secretKey;
    private static final String CRYPTO_ALGO = "AES/CBC/PKCS5Padding";
    private static final String KEY_ALGO = "AES";
    private final Decoder<Object> decoder = new Decoder<Object>(){

        public Object decode(ByteBuf buf, State state) throws IOException {
            int rawLength = buf.readableBytes();
            byte[] rawBytes = new byte[rawLength];
            buf.readBytes(rawBytes);
            byte[] clearBytes = RedisEncryptionCodec.doCipher(2, RedisEncryptionCodec.this.secretKey, rawBytes);
            ByteBuf bf = Unpooled.wrappedBuffer((byte[])clearBytes);
            return RedisEncryptionCodec.this.innerCodec.getValueDecoder().decode(bf, state);
        }
    };
    private final Encoder encoder = new Encoder(){

        public byte[] encode(Object in) throws IOException {
            byte[] innerCodecBytes = RedisEncryptionCodec.this.innerCodec.getValueEncoder().encode(in);
            byte[] cipherBytes = RedisEncryptionCodec.doCipher(1, RedisEncryptionCodec.this.secretKey, innerCodecBytes);
            return cipherBytes;
        }
    };

    public RedisEncryptionCodec(String rawSecretKey, Codec innerCodec) {
        this.secretKey = RedisEncryptionCodec.createKey(rawSecretKey);
        this.innerCodec = innerCodec;
    }

    private static SecretKey createKey(String rawSecretKey) {
        try {
            byte[] key = rawSecretKey.getBytes("UTF-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            byte[] finalKey = Arrays.copyOf(key, 16);
            return new SecretKeySpec(finalKey, KEY_ALGO);
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    private static byte[] doCipher(int mode, SecretKey key, byte[] rawBytes) {
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGO);
            cipher.init(mode, key);
            return cipher.doFinal(rawBytes);
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public Decoder<Object> getMapValueDecoder() {
        return this.getValueDecoder();
    }

    public Encoder getMapValueEncoder() {
        return this.getValueEncoder();
    }

    public Decoder<Object> getMapKeyDecoder() {
        return this.getValueDecoder();
    }

    public Encoder getMapKeyEncoder() {
        return this.getValueEncoder();
    }

    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

