/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class RedisCompressionCodec
implements Codec {
    private final LZ4Factory factory = LZ4Factory.fastestJavaInstance();
    private final Codec innerCodec;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        public Object decode(ByteBuf buf, State state) throws IOException {
            int rawLength = buf.readableBytes();
            int compressedLength = rawLength - 4;
            byte[] compressedBytes = new byte[compressedLength];
            Integer decompressedLength = buf.readInt();
            buf.readBytes(compressedBytes);
            byte[] decompressedBytes = new byte[decompressedLength.intValue()];
            LZ4SafeDecompressor decompressor = RedisCompressionCodec.this.factory.safeDecompressor();
            decompressor.decompress(compressedBytes, decompressedBytes);
            ByteBuf bf = Unpooled.wrappedBuffer((byte[])decompressedBytes);
            return RedisCompressionCodec.this.innerCodec.getValueDecoder().decode(bf, state);
        }
    };
    private final Encoder encoder = new Encoder(){

        public byte[] encode(Object in) throws IOException {
            LZ4Compressor compressor = RedisCompressionCodec.this.factory.highCompressor();
            byte[] uncompressedBytes = RedisCompressionCodec.this.innerCodec.getValueEncoder().encode(in);
            byte[] compressedBytes = compressor.compress(uncompressedBytes);
            ByteBuffer buffer = ByteBuffer.allocate(compressedBytes.length + 4);
            buffer.putInt(uncompressedBytes.length);
            buffer.put(compressedBytes);
            return buffer.array();
        }
    };

    public RedisCompressionCodec(Codec innerCodec) {
        this.innerCodec = innerCodec;
    }

    public Decoder<Object> getMapValueDecoder() {
        return this.getValueDecoder();
    }

    public Encoder getMapValueEncoder() {
        return this.getValueEncoder();
    }

    public Decoder<Object> getMapKeyDecoder() {
        return this.getValueDecoder();
    }

    public Encoder getMapKeyEncoder() {
        return this.getValueEncoder();
    }

    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

