/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;

public class RedisClusterConfig {
    private List<String> actorDirectoryUris = Arrays.asList("redis://localhost");
    private Boolean actorDirectoryClustered = false;
    private List<String> nodeDirectoryUris = Arrays.asList("redis://localhost");
    private Boolean nodeDirectoryClustered = false;
    private List<String> messagingUris = Arrays.asList("redis://localhost");
    private Boolean messagingClustered = false;
    private Integer nodeLifetimeSeconds = 20;
    private Integer maxRedisConnections = 10;
    private Integer connectionTimeout = 3000;
    private Integer generalTimeout = 3000;
    private Integer idleTimeout = 3000;
    private Integer reconnectionTimeout = 3000;
    private Integer pingTimeout = 3000;
    private Integer retryAttempts = 6;
    private Integer retryInterval = 10000;
    private Integer shardingBuckets = 256;
    private Boolean useCompression = true;
    private Boolean useEncryption = false;
    private String encryptionKey = "";
    private ExecutorService executorService = ForkJoinPool.commonPool();

    public List<String> getActorDirectoryUris() {
        return this.actorDirectoryUris;
    }

    public void setActorDirectoryUris(List<String> actorDirectoryUris) {
        this.actorDirectoryUris = Collections.unmodifiableList(actorDirectoryUris);
    }

    public List<String> getNodeDirectoryUris() {
        return this.nodeDirectoryUris;
    }

    public void setNodeDirectoryUris(List<String> nodeDirectoryUris) {
        this.nodeDirectoryUris = Collections.unmodifiableList(nodeDirectoryUris);
    }

    public List<String> getMessagingUris() {
        return this.messagingUris;
    }

    public void setMessagingUris(List<String> messagingUris) {
        this.messagingUris = Collections.unmodifiableList(messagingUris);
    }

    public Boolean getMessagingClustered() {
        return this.messagingClustered;
    }

    public void setMessagingClustered(Boolean messagingClustered) {
        this.messagingClustered = messagingClustered;
    }

    public Boolean getActorDirectoryClustered() {
        return this.actorDirectoryClustered;
    }

    public void setActorDirectoryClustered(Boolean actorDirectoryClustered) {
        this.actorDirectoryClustered = actorDirectoryClustered;
    }

    public Boolean getNodeDirectoryClustered() {
        return this.nodeDirectoryClustered;
    }

    public void setNodeDirectoryClustered(Boolean nodeDirectoryClustered) {
        this.nodeDirectoryClustered = nodeDirectoryClustered;
    }

    public Integer getNodeLifetimeSeconds() {
        return this.nodeLifetimeSeconds;
    }

    public void setNodeLifetimeSeconds(Integer nodeLifetimeSeconds) {
        this.nodeLifetimeSeconds = nodeLifetimeSeconds;
    }

    public Integer getMaxRedisConnections() {
        return this.maxRedisConnections;
    }

    public void setMaxRedisConnections(Integer maxRedisConnections) {
        this.maxRedisConnections = maxRedisConnections;
    }

    public Boolean getUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(Boolean useCompression) {
        this.useCompression = useCompression;
    }

    public Boolean getUseEncryption() {
        return this.useEncryption;
    }

    public void setUseEncryption(Boolean useEncryption) {
        this.useEncryption = useEncryption;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getGeneralTimeout() {
        return this.generalTimeout;
    }

    public void setGeneralTimeout(Integer generalTimeout) {
        this.generalTimeout = generalTimeout;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Integer getReconnectionTimeout() {
        return this.reconnectionTimeout;
    }

    public void setReconnectionTimeout(Integer reconnectionTimeout) {
        this.reconnectionTimeout = reconnectionTimeout;
    }

    public Integer getPingTimeout() {
        return this.pingTimeout;
    }

    public void setPingTimeout(Integer pingTimeout) {
        this.pingTimeout = pingTimeout;
    }

    public Integer getRetryAttempts() {
        return this.retryAttempts;
    }

    public void setRetryAttempts(Integer retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Integer getShardingBuckets() {
        return this.shardingBuckets;
    }

    public void setShardingBuckets(Integer shardingBuckets) {
        this.shardingBuckets = shardingBuckets;
    }
}

