/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class RedisCompressionCodec
implements Codec {
    private final LZ4Factory factory = LZ4Factory.fastestJavaInstance();
    private final Codec innerCodec;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        public Object decode(ByteBuf buf, State state) throws IOException {
            int rawLength = buf.readableBytes();
            byte[] compressedBytes = new byte[rawLength - 4];
            Integer decompressedLength = buf.readInt();
            buf.readBytes(compressedBytes);
            byte[] outBuf = new byte[decompressedLength.intValue()];
            LZ4SafeDecompressor decompressor = RedisCompressionCodec.this.factory.safeDecompressor();
            decompressor.decompress(compressedBytes, outBuf);
            ByteBuf bf = Unpooled.wrappedBuffer((byte[])outBuf);
            return RedisCompressionCodec.this.innerCodec.getValueDecoder().decode(bf, state);
        }
    };
    private final Encoder encoder = new Encoder(){

        public byte[] encode(Object in) throws IOException {
            LZ4Compressor compressor = RedisCompressionCodec.this.factory.highCompressor();
            byte[] innerCodecBytes = RedisCompressionCodec.this.innerCodec.getValueEncoder().encode(in);
            byte[] wireBytes = compressor.compress(innerCodecBytes);
            ByteBuffer buffer = ByteBuffer.allocate(wireBytes.length + 4);
            buffer.putInt(innerCodecBytes.length);
            buffer.put(wireBytes);
            return buffer.array();
        }
    };

    public RedisCompressionCodec(Codec innerCodec) {
        this.innerCodec = innerCodec;
    }

    public Decoder<Object> getMapValueDecoder() {
        return this.getValueDecoder();
    }

    public Encoder getMapValueEncoder() {
        return this.getValueEncoder();
    }

    public Decoder<Object> getMapKeyDecoder() {
        return this.getValueDecoder();
    }

    public Encoder getMapKeyEncoder() {
        return this.getValueEncoder();
    }

    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

