/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import cloud.orbit.exception.NotImplementedException;
import com.github.ssedano.hash.JumpConsistentHash;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;

public class RedisShardedMap<K, V>
implements ConcurrentMap<K, V> {
    private final Integer bucketCount;
    private final RedissonClient redissonClient;
    private final String mapName;
    private final ConcurrentMap<String, ConcurrentMap<K, V>> cacheManager = new ConcurrentHashMap<String, ConcurrentMap<K, V>>();

    public RedisShardedMap(String mapName, RedissonClient redissonClient, Integer bucketCount) {
        this.mapName = mapName;
        this.redissonClient = redissonClient;
        this.bucketCount = bucketCount;
    }

    private ConcurrentMap<K, V> getBucketMap(Integer bucket) {
        RMap temp;
        String realName = this.mapName + "#" + bucket;
        ConcurrentMap result = (ConcurrentMap)this.cacheManager.get(realName);
        if (result == null && (result = (ConcurrentMap)this.cacheManager.putIfAbsent(realName, (ConcurrentMap<String, RMap>)(temp = this.redissonClient.getMap(realName)))) == null) {
            result = temp;
        }
        return result;
    }

    private ConcurrentMap<K, V> getRealMap(Object key) {
        Integer bucket = JumpConsistentHash.jumpConsistentHash((Object)key, (int)this.bucketCount);
        return this.getBucketMap(bucket);
    }

    @Override
    public int size() {
        int result = 0;
        for (int i = 0; i < this.bucketCount; ++i) {
            result += this.getBucketMap(i).size();
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.bucketCount; ++i) {
            if (this.getBucketMap(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        for (int i = 0; i < this.bucketCount; ++i) {
            if (!this.getBucketMap(i).containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.bucketCount; ++i) {
            if (!this.getBucketMap(i).containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.getRealMap(key).get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.getRealMap(key).put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.getRealMap(key).remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach((key, val) -> this.getRealMap(key).put(key, val));
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.bucketCount; ++i) {
            this.getBucketMap(i).clear();
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.getRealMap(key).putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.getRealMap(key).remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.getRealMap(key).replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.getRealMap(key).replace(key, value);
    }

    @Override
    public Set<K> keySet() {
        throw new NotImplementedException("Can not use sets on sharded map");
    }

    @Override
    public Collection<V> values() {
        throw new NotImplementedException("Can not use sets on sharded map");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new NotImplementedException("Can not use sets on sharded map");
    }
}

