/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import cloud.orbit.actors.cluster.RedisClusterConfig;
import cloud.orbit.actors.cluster.impl.RedisCompressionCodec;
import cloud.orbit.actors.cluster.impl.RedisEncryptionCodec;
import cloud.orbit.exception.UncheckedException;
import com.github.ssedano.hash.JumpConsistentHash;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.codec.SerializationCodec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.ReadMode;

public class RedisDB {
    private RedisClusterConfig redisClusterConfig = null;
    private RedissonClient nodeDirectoryClient = null;
    private RedissonClient actorDirectoryClient = null;
    private List<RedissonClient> messagingClients = new ArrayList<RedissonClient>();

    public RedisDB(RedisClusterConfig redisClusterConfig) {
        this.redisClusterConfig = redisClusterConfig;
        this.nodeDirectoryClient = this.createClient(redisClusterConfig.getNodeDirectoryUri(), redisClusterConfig.getNodeDirectoryClustered(), true);
        this.actorDirectoryClient = this.createClient(redisClusterConfig.getActorDirectoryUri(), redisClusterConfig.getActorDirectoryClustered(), true);
        List<String> masters = redisClusterConfig.getMessagingUris();
        for (String uri : masters) {
            this.messagingClients.add(this.createClient(uri, false, false));
        }
    }

    public RedissonClient getNodeDirectoryClient() {
        return this.nodeDirectoryClient;
    }

    public RedissonClient getActorDirectoryClient() {
        return this.actorDirectoryClient;
    }

    public RedissonClient getMessagingClient(String channel) {
        int jumpConsistentHash = JumpConsistentHash.jumpConsistentHash((Object)channel, (int)this.messagingClients.size());
        return this.messagingClients.get(jumpConsistentHash);
    }

    private RedissonClient createClient(String uri, Boolean clustered, Boolean useJavaSerializer) {
        Integer port;
        URI realUri = URI.create(uri);
        if (!realUri.getScheme().equalsIgnoreCase("redis")) {
            throw new UncheckedException("Invalid Redis URI.");
        }
        String host = realUri.getHost();
        if (host == null) {
            host = "localhost";
        }
        if ((port = Integer.valueOf(realUri.getPort())) == -1) {
            port = 6379;
        }
        String resolvedUri = host + ":" + port;
        Config redissonConfig = new Config();
        Object currentCodec = useJavaSerializer != false ? new SerializationCodec() : new JsonJacksonCodec();
        if (this.redisClusterConfig.getUseCompression().booleanValue()) {
            currentCodec = new RedisCompressionCodec((Codec)currentCodec);
        }
        if (this.redisClusterConfig.getUseEncryption().booleanValue()) {
            currentCodec = new RedisEncryptionCodec(this.redisClusterConfig.getEncryptionKey(), (Codec)currentCodec);
        }
        redissonConfig.setCodec((Codec)currentCodec);
        if (clustered.booleanValue()) {
            ((ClusterServersConfig)((ClusterServersConfig)redissonConfig.useClusterServers().addNodeAddress(new String[]{resolvedUri}).setMasterConnectionPoolSize(this.redisClusterConfig.getMaxRedisConnections().intValue())).setMasterConnectionMinimumIdleSize(1)).setReadMode(ReadMode.MASTER);
        } else {
            redissonConfig.useSingleServer().setAddress(resolvedUri).setConnectionPoolSize(this.redisClusterConfig.getMaxRedisConnections().intValue()).setConnectionMinimumIdleSize(1);
        }
        return Redisson.create((Config)redissonConfig);
    }
}

