/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster;

import cloud.orbit.actors.cluster.RedisClusterConfig;
import cloud.orbit.actors.cluster.RedisClusterPeer;
import java.util.List;

public class RedisClusterBuilder {
    private RedisClusterConfig redisClusterConfig = new RedisClusterConfig();

    public RedisClusterBuilder nodeDirectoryUri(String nodeDirectoryUri) {
        return this.nodeDirectoryUri(nodeDirectoryUri, false);
    }

    public RedisClusterBuilder nodeDirectoryUri(String nodeDirectoryUri, Boolean clustered) {
        this.redisClusterConfig.setNodeDirectoryUri(nodeDirectoryUri);
        this.redisClusterConfig.setNodeDirectoryClustered(clustered);
        return this;
    }

    public RedisClusterBuilder actorDirectoryUri(String actorDirectoryUri) {
        return this.actorDirectoryUri(actorDirectoryUri, false);
    }

    public RedisClusterBuilder actorDirectoryUri(String actorDirectoryUri, Boolean clustered) {
        this.redisClusterConfig.setActorDirectoryUri(actorDirectoryUri);
        this.redisClusterConfig.setActorDirectoryClustered(clustered);
        return this;
    }

    public RedisClusterBuilder messagingUris(List<String> messagingUris) {
        this.redisClusterConfig.setMessagingUris(messagingUris);
        return this;
    }

    public RedisClusterBuilder nodeLifetimeSecs(Integer nodeLifetimeSecs) {
        this.redisClusterConfig.setNodeLifetimeSeconds(nodeLifetimeSecs);
        return this;
    }

    public RedisClusterBuilder maxRedisConnections(Integer maxRedisConnections) {
        this.redisClusterConfig.setMaxRedisConnections(maxRedisConnections);
        return this;
    }

    public RedisClusterBuilder enableActorDirectoryHashing(Integer clusteredActoryDirectoryBuckets) {
        this.redisClusterConfig.setActorDirectoryHashingEnabled(true);
        this.redisClusterConfig.setActorDirectoryHashBuckets(clusteredActoryDirectoryBuckets);
        return this;
    }

    public RedisClusterBuilder disableClusteredActorDirectory() {
        this.redisClusterConfig.setActorDirectoryHashingEnabled(false);
        this.redisClusterConfig.setActorDirectoryHashBuckets(0);
        return this;
    }

    public RedisClusterPeer build() {
        return new RedisClusterPeer(this.redisClusterConfig);
    }
}

