/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import cloud.orbit.exception.UncheckedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;

public class RedisSerializer {
    static <T> String serialize(T myClass) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(myClass);
            oos.close();
            return Base64.getEncoder().encodeToString(baos.toByteArray());
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    static <T> T deserialize(String input) {
        try {
            byte[] stream = Base64.getDecoder().decode(input);
            ByteArrayInputStream bais = new ByteArrayInputStream(stream);
            ObjectInputStream ois = new ObjectInputStream(bais);
            ois.close();
            return (T)ois.readObject();
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }
}

