/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster.impl;

import cloud.orbit.actors.cluster.impl.RedisDB;
import cloud.orbit.actors.cluster.impl.RedisKeyGenerator;
import cloud.orbit.actors.cluster.impl.RedisSerializer;
import cloud.orbit.exception.NotImplementedException;
import cloud.orbit.tuples.Pair;
import com.lambdaworks.redis.ScriptOutputType;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class RedisConcurrentMap<K, V>
implements ConcurrentMap<K, V> {
    private final RedisDB redisDb;
    private final String prefix;

    public RedisConcurrentMap(String name, String clusterName, RedisDB redisDb) {
        this.redisDb = redisDb;
        this.prefix = RedisKeyGenerator.key(name, Pair.of((Object)"clusterName", (Object)clusterName)) + "=";
    }

    @Override
    public V get(Object key) {
        String res = (String)this.redisDb.getGenericConnection().get((Object)(this.prefix + key.toString()));
        if (res == null) {
            return null;
        }
        return (V)RedisSerializer.deserialize(res);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.redisDb.getGenericConnection().get((Object)(this.prefix + key.toString())) != null;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V result = this.get(key);
        return result != null ? result : defaultValue;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (this.redisDb.getGenericConnection().setnx((Object)(this.prefix + key.toString()), (Object)RedisSerializer.serialize(value)).booleanValue()) {
            return null;
        }
        return this.get(key);
    }

    @Override
    public V put(K key, V value) {
        String ret = (String)this.redisDb.getGenericConnection().getset((Object)(this.prefix + key.toString()), (Object)RedisSerializer.serialize(value));
        if (ret == null) {
            return null;
        }
        return (V)RedisSerializer.deserialize(ret);
    }

    @Override
    public V remove(Object key) {
        V res = this.get(key);
        this.redisDb.getGenericConnection().del((Object[])new String[]{this.prefix + key.toString()});
        return res;
    }

    @Override
    public boolean remove(Object key, Object value) {
        String script = "local currentVal = redis.call(\"GET\", KEYS[1])    if(ARGV[1] == currentVal) then        redis.call(\"DEL\", KEYS[1])        return true    end    return false";
        String existingCheck = RedisSerializer.serialize(value);
        String realKey = this.prefix + key.toString();
        Boolean res = (Boolean)this.redisDb.getGenericConnection().eval("local currentVal = redis.call(\"GET\", KEYS[1])    if(ARGV[1] == currentVal) then        redis.call(\"DEL\", KEYS[1])        return true    end    return false", ScriptOutputType.BOOLEAN, (Object[])new String[]{realKey}, (Object[])new String[]{existingCheck});
        return res;
    }

    @Override
    public V replace(K key, V value) {
        throw new NotImplementedException();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new NotImplementedException();
    }

    @Override
    public int hashCode() {
        throw new NotImplementedException();
    }

    @Override
    public boolean equals(Object o) {
        throw new NotImplementedException();
    }

    @Override
    public Collection<V> values() {
        throw new NotImplementedException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new NotImplementedException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new NotImplementedException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new NotImplementedException();
    }

    @Override
    public void clear() {
        throw new NotImplementedException();
    }

    @Override
    public int size() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isEmpty() {
        throw new NotImplementedException();
    }

    @Override
    public Set<K> keySet() {
        throw new NotImplementedException();
    }
}

