/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster;

import cloud.orbit.actors.cluster.ClusterPeer;
import cloud.orbit.actors.cluster.MessageListener;
import cloud.orbit.actors.cluster.NodeAddress;
import cloud.orbit.actors.cluster.NodeAddressImpl;
import cloud.orbit.actors.cluster.ViewListener;
import cloud.orbit.actors.cluster.impl.RedisConcurrentMap;
import cloud.orbit.actors.cluster.impl.RedisDB;
import cloud.orbit.actors.cluster.impl.RedisKeyGenerator;
import cloud.orbit.actors.cluster.impl.RedisPubSubListener;
import cloud.orbit.concurrent.Task;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisClusterPeer
implements ClusterPeer {
    private static Logger logger = LoggerFactory.getLogger(RedisClusterPeer.class);
    private ViewListener viewListener;
    private MessageListener messageListener;
    private NodeAddress localAddress = new NodeAddressImpl(UUID.randomUUID());
    private String clusterName;
    private final RedisDB redisDb = new RedisDB();
    private final String redisUri;
    private final Integer nodeLifetimeSecs;
    private final ConcurrentMap<String, RedisConcurrentMap<?, ?>> cacheManager = new ConcurrentHashMap();
    private RedisPubSubListener pubSubListener = new RedisPubSubListener(this);

    public RedisClusterPeer(String redisUri) {
        this(redisUri, 20);
    }

    public RedisClusterPeer() {
        this("redis://localhost", 20);
    }

    public RedisClusterPeer(String redisUri, Integer nodeLifetimeSecs) {
        this.redisUri = redisUri;
        this.nodeLifetimeSecs = nodeLifetimeSecs;
    }

    public <K, V> ConcurrentMap<K, V> getCache(String name) {
        RedisConcurrentMap temp;
        RedisConcurrentMap result = (RedisConcurrentMap)this.cacheManager.get(name);
        if (result == null && (result = this.cacheManager.putIfAbsent(name, temp = new RedisConcurrentMap(name, this.clusterName, this.redisDb))) == null) {
            result = temp;
        }
        return result;
    }

    public NodeAddress localAddress() {
        return this.localAddress;
    }

    public Task<?> join(String clusterName, String nodeName) {
        logger.info("Joining Redis Cluster...");
        this.clusterName = clusterName;
        this.redisDb.init(this.redisUri);
        String nodeKey = RedisKeyGenerator.nodeKey(clusterName, this.localAddress.toString());
        this.redisDb.getPubSubConnection().addListener((com.lambdaworks.redis.pubsub.RedisPubSubListener)this.pubSubListener);
        this.redisDb.getPubSubConnection().subscribe((Object[])new String[]{nodeKey});
        this.writeMyEntry();
        this.syncNodes();
        return Task.done();
    }

    private void writeMyEntry() {
        String nodeKey = RedisKeyGenerator.nodeKey(this.clusterName, this.localAddress.toString());
        this.redisDb.getGenericConnection().setex((Object)nodeKey, (long)this.nodeLifetimeSecs.intValue(), (Object)this.localAddress.toString());
    }

    private void syncNodes() {
        String nodeKey = RedisKeyGenerator.nodeKey(this.clusterName, "*");
        ArrayList<NodeAddressImpl> nodeAddresses = new ArrayList<NodeAddressImpl>();
        List keys = this.redisDb.getGenericConnection().keys((Object)nodeKey);
        for (String key : keys) {
            String rawKey = (String)this.redisDb.getGenericConnection().get((Object)key);
            nodeAddresses.add(new NodeAddressImpl(UUID.fromString(rawKey)));
        }
        this.viewListener.onViewChange(nodeAddresses);
    }

    public void sendMessage(NodeAddress toAddress, byte[] message) {
        String targetNodeKey = RedisKeyGenerator.nodeKey(this.clusterName, toAddress.toString());
        String rawMessage = this.localAddress.toString() + "//" + Base64.getEncoder().encodeToString(message);
        this.redisDb.getGenericConnection().publish((Object)targetNodeKey, (Object)rawMessage);
    }

    public void receiveMessage(String rawMessage) {
        Integer splitPoint = rawMessage.indexOf("//");
        if (splitPoint != -1) {
            String rawNodeAddr = rawMessage.substring(0, splitPoint);
            String rawContents = rawMessage.substring(splitPoint + 2);
            NodeAddressImpl nodeAddr = new NodeAddressImpl(UUID.fromString(rawNodeAddr));
            byte[] contents = Base64.getDecoder().decode(rawContents);
            this.messageListener.receive((NodeAddress)nodeAddr, contents);
        }
    }

    public Task pulse() {
        this.writeMyEntry();
        this.syncNodes();
        return Task.done();
    }

    public void leave() {
        String nodeKey = RedisKeyGenerator.nodeKey(this.clusterName, this.localAddress.toString());
        this.redisDb.getGenericConnection().del((Object[])new String[]{nodeKey});
    }

    public void registerMessageReceiver(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void registerViewListener(ViewListener viewListener) {
        this.viewListener = viewListener;
    }
}

