package orbit.shared.proto

import io.rouz.grpc.*
import orbit.shared.proto.ConnectionGrpc.ConnectionStub

import kotlinx.coroutines.channels.ReceiveChannel
import kotlin.coroutines.suspendCoroutine

import io.grpc.Metadata
import io.grpc.stub.MetadataUtils

/**
 * Kotlin extension functions for [orbit.shared.proto.ConnectionGrpc.ConnectionStub]
 *
 * Generated by gRPC Kotlin generator
 * Source: orbit/shared/connection.proto
 */




fun ConnectionStub.openStream(): ManyToManyCall<orbit.shared.proto.Messages.MessageProto, orbit.shared.proto.Messages.MessageProto> {
    val responseChannel = StreamObserverChannel<orbit.shared.proto.Messages.MessageProto>()
    val requestObserver = openStream(responseChannel)
    return ManyToManyCall(requestObserver, responseChannel)
}

/**
* Adds new binary header and returns the client
*/
fun ConnectionStub.addBinaryHeader(
    header: String,
    bytes: ByteArray
): ConnectionStub {
    val headers = Metadata()
    val key = Metadata.Key.of(header, Metadata.BINARY_BYTE_MARSHALLER)
    headers.put(key, bytes)

    return MetadataUtils.attachHeaders(this, headers)
}
