package orbit.shared.proto

import orbit.shared.proto.NodeManagementGrpc.*

import io.grpc.*
import io.grpc.stub.*
import io.rouz.grpc.*

import kotlin.coroutines.*
import kotlinx.coroutines.*
import kotlinx.coroutines.channels.*



@javax.annotation.Generated(
    value = ["by gRPC Kotlin generator"],
    comments = "Source: orbit/shared/node_management.proto"
)
abstract class NodeManagementImplBase(
    coroutineContext: CoroutineContext = Dispatchers.Default
) : BindableService, CoroutineScope {

    private val _coroutineContext: CoroutineContext = coroutineContext

    override val coroutineContext: CoroutineContext
        get() = ContextCoroutineContextElement() + _coroutineContext

    
    
    
    open suspend fun joinCluster(request: orbit.shared.proto.NodeManagementOuterClass.JoinClusterRequestProto): orbit.shared.proto.NodeManagementOuterClass.NodeLeaseResponseProto {
        throw unimplemented(getJoinClusterMethod()).asRuntimeException()
    }

    internal fun joinClusterInternal(
        request: orbit.shared.proto.NodeManagementOuterClass.JoinClusterRequestProto,
        responseObserver: StreamObserver<orbit.shared.proto.NodeManagementOuterClass.NodeLeaseResponseProto>
    ) {
        launch {
            tryCatchingStatus(responseObserver) {
                val response = joinCluster(request)
                onNext(response)
            }
        }
    }
    
    
    
    open suspend fun renewLease(request: orbit.shared.proto.NodeManagementOuterClass.RenewNodeLeaseRequestProto): orbit.shared.proto.NodeManagementOuterClass.NodeLeaseResponseProto {
        throw unimplemented(getRenewLeaseMethod()).asRuntimeException()
    }

    internal fun renewLeaseInternal(
        request: orbit.shared.proto.NodeManagementOuterClass.RenewNodeLeaseRequestProto,
        responseObserver: StreamObserver<orbit.shared.proto.NodeManagementOuterClass.NodeLeaseResponseProto>
    ) {
        launch {
            tryCatchingStatus(responseObserver) {
                val response = renewLease(request)
                onNext(response)
            }
        }
    }
    
    
    
    open suspend fun leaveCluster(request: orbit.shared.proto.NodeManagementOuterClass.LeaveClusterRequestProto): orbit.shared.proto.NodeManagementOuterClass.NodeLeaseResponseProto {
        throw unimplemented(getLeaveClusterMethod()).asRuntimeException()
    }

    internal fun leaveClusterInternal(
        request: orbit.shared.proto.NodeManagementOuterClass.LeaveClusterRequestProto,
        responseObserver: StreamObserver<orbit.shared.proto.NodeManagementOuterClass.NodeLeaseResponseProto>
    ) {
        launch {
            tryCatchingStatus(responseObserver) {
                val response = leaveCluster(request)
                onNext(response)
            }
        }
    }

    override fun bindService(): ServerServiceDefinition {
        return ServerServiceDefinition.builder(getServiceDescriptor())
            .addMethod(
                getJoinClusterMethod(),
                ServerCalls.asyncUnaryCall(
                    MethodHandlers(METHODID_JOIN_CLUSTER)
                )
            )
            .addMethod(
                getRenewLeaseMethod(),
                ServerCalls.asyncUnaryCall(
                    MethodHandlers(METHODID_RENEW_LEASE)
                )
            )
            .addMethod(
                getLeaveClusterMethod(),
                ServerCalls.asyncUnaryCall(
                    MethodHandlers(METHODID_LEAVE_CLUSTER)
                )
            )
            .build()
    }

    private fun unimplemented(methodDescriptor: MethodDescriptor<*, *>): Status {
        return Status.UNIMPLEMENTED
            .withDescription("Method ${methodDescriptor.fullMethodName} is unimplemented")
    }

    private fun <E> handleException(t: Throwable?, responseObserver: StreamObserver<E>) {
        when (t) {
            null -> return
            is CancellationException -> handleException(t.cause, responseObserver)
            is StatusException, is StatusRuntimeException -> responseObserver.onError(t)
            is RuntimeException -> {
                responseObserver.onError(Status.UNKNOWN.asRuntimeException())
                throw t
            }
            is Exception -> {
                responseObserver.onError(Status.UNKNOWN.asException())
                throw t
            }
            else -> {
                responseObserver.onError(Status.INTERNAL.asException())
                throw t
            }
        }
    }

    private suspend fun <E> tryCatchingStatus(responseObserver: StreamObserver<E>, body: suspend StreamObserver<E>.() -> Unit) {
        try {
            responseObserver.body()
            responseObserver.onCompleted()
        } catch (t: Throwable) {
            handleException(t, responseObserver)
        }
    }

    private val METHODID_JOIN_CLUSTER = 0
    private val METHODID_RENEW_LEASE = 1
    private val METHODID_LEAVE_CLUSTER = 2

    private inner class MethodHandlers<Req, Resp> internal constructor(
        private val methodId: Int
    ) : ServerCalls.UnaryMethod<Req, Resp>,
        ServerCalls.ServerStreamingMethod<Req, Resp>,
        ServerCalls.ClientStreamingMethod<Req, Resp>,
        ServerCalls.BidiStreamingMethod<Req, Resp> {

        @Suppress("UNCHECKED_CAST")
        override fun invoke(request: Req, responseObserver: StreamObserver<Resp>) {
            when (methodId) {
                METHODID_JOIN_CLUSTER ->
                    this@NodeManagementImplBase.joinClusterInternal(
                        request as orbit.shared.proto.NodeManagementOuterClass.JoinClusterRequestProto,
                        responseObserver as StreamObserver<orbit.shared.proto.NodeManagementOuterClass.NodeLeaseResponseProto>
                    )
                METHODID_RENEW_LEASE ->
                    this@NodeManagementImplBase.renewLeaseInternal(
                        request as orbit.shared.proto.NodeManagementOuterClass.RenewNodeLeaseRequestProto,
                        responseObserver as StreamObserver<orbit.shared.proto.NodeManagementOuterClass.NodeLeaseResponseProto>
                    )
                METHODID_LEAVE_CLUSTER ->
                    this@NodeManagementImplBase.leaveClusterInternal(
                        request as orbit.shared.proto.NodeManagementOuterClass.LeaveClusterRequestProto,
                        responseObserver as StreamObserver<orbit.shared.proto.NodeManagementOuterClass.NodeLeaseResponseProto>
                    )
                else -> throw AssertionError()
            }
        }

        @Suppress("UNCHECKED_CAST")
        override fun invoke(responseObserver: StreamObserver<Resp>): StreamObserver<Req> {
            when (methodId) {
                else -> throw AssertionError()
            }
        }
    }
}
