package orbit.shared.proto

import orbit.shared.proto.ConnectionGrpc.*

import io.grpc.*
import io.grpc.stub.*
import io.rouz.grpc.*

import kotlin.coroutines.*
import kotlinx.coroutines.*
import kotlinx.coroutines.channels.*



@javax.annotation.Generated(
    value = ["by gRPC Kotlin generator"],
    comments = "Source: orbit/shared/connection.proto"
)
abstract class ConnectionImplBase(
    coroutineContext: CoroutineContext = Dispatchers.Default
) : BindableService, CoroutineScope {

    private val _coroutineContext: CoroutineContext = coroutineContext

    override val coroutineContext: CoroutineContext
        get() = ContextCoroutineContextElement() + _coroutineContext

    
    
    
    open fun openStream(requests: ReceiveChannel<orbit.shared.proto.Messages.MessageProto>): ReceiveChannel<orbit.shared.proto.Messages.MessageProto> {
        throw unimplemented(getOpenStreamMethod()).asRuntimeException()
    }

    internal fun openStreamInternal(
        responseObserver: StreamObserver<orbit.shared.proto.Messages.MessageProto>
    ): StreamObserver<orbit.shared.proto.Messages.MessageProto> {
        val requests = StreamObserverChannel<orbit.shared.proto.Messages.MessageProto>()
        launch {
            tryCatchingStatus(responseObserver) {
                val responses = openStream(requests)
                for (response in responses) {
                    try {
                        onNext(response)
                    } catch (e: Throwable) {
                        responses.cancel()
                        throw e
                    }
                }
            }
        }
        return requests
    }

    override fun bindService(): ServerServiceDefinition {
        return ServerServiceDefinition.builder(getServiceDescriptor())
            .addMethod(
                getOpenStreamMethod(),
                ServerCalls.asyncBidiStreamingCall(
                    MethodHandlers(METHODID_OPEN_STREAM)
                )
            )
            .build()
    }

    private fun unimplemented(methodDescriptor: MethodDescriptor<*, *>): Status {
        return Status.UNIMPLEMENTED
            .withDescription("Method ${methodDescriptor.fullMethodName} is unimplemented")
    }

    private fun <E> handleException(t: Throwable?, responseObserver: StreamObserver<E>) {
        when (t) {
            null -> return
            is CancellationException -> handleException(t.cause, responseObserver)
            is StatusException, is StatusRuntimeException -> responseObserver.onError(t)
            is RuntimeException -> {
                responseObserver.onError(Status.UNKNOWN.asRuntimeException())
                throw t
            }
            is Exception -> {
                responseObserver.onError(Status.UNKNOWN.asException())
                throw t
            }
            else -> {
                responseObserver.onError(Status.INTERNAL.asException())
                throw t
            }
        }
    }

    private suspend fun <E> tryCatchingStatus(responseObserver: StreamObserver<E>, body: suspend StreamObserver<E>.() -> Unit) {
        try {
            responseObserver.body()
            responseObserver.onCompleted()
        } catch (t: Throwable) {
            handleException(t, responseObserver)
        }
    }

    private val METHODID_OPEN_STREAM = 0

    private inner class MethodHandlers<Req, Resp> internal constructor(
        private val methodId: Int
    ) : ServerCalls.UnaryMethod<Req, Resp>,
        ServerCalls.ServerStreamingMethod<Req, Resp>,
        ServerCalls.ClientStreamingMethod<Req, Resp>,
        ServerCalls.BidiStreamingMethod<Req, Resp> {

        @Suppress("UNCHECKED_CAST")
        override fun invoke(request: Req, responseObserver: StreamObserver<Resp>) {
            when (methodId) {
                else -> throw AssertionError()
            }
        }

        @Suppress("UNCHECKED_CAST")
        override fun invoke(responseObserver: StreamObserver<Resp>): StreamObserver<Req> {
            when (methodId) {
                METHODID_OPEN_STREAM ->
                    return this@ConnectionImplBase.openStreamInternal(
                        responseObserver as StreamObserver<orbit.shared.proto.Messages.MessageProto>
                    ) as StreamObserver<Req>
                else -> throw AssertionError()
            }
        }
    }
}
