package grpc.health.v1

import grpc.health.v1.HealthGrpc.*

import io.grpc.*
import io.grpc.stub.*
import io.rouz.grpc.*

import kotlin.coroutines.*
import kotlinx.coroutines.*
import kotlinx.coroutines.channels.*



@javax.annotation.Generated(
    value = ["by gRPC Kotlin generator"],
    comments = "Source: orbit/shared/health.proto"
)
abstract class HealthImplBase(
    coroutineContext: CoroutineContext = Dispatchers.Default
) : BindableService, CoroutineScope {

    private val _coroutineContext: CoroutineContext = coroutineContext

    override val coroutineContext: CoroutineContext
        get() = ContextCoroutineContextElement() + _coroutineContext

    
    
    
    open suspend fun check(request: grpc.health.v1.HealthOuterClass.HealthCheckRequest): grpc.health.v1.HealthOuterClass.HealthCheckResponse {
        throw unimplemented(getCheckMethod()).asRuntimeException()
    }

    internal fun checkInternal(
        request: grpc.health.v1.HealthOuterClass.HealthCheckRequest,
        responseObserver: StreamObserver<grpc.health.v1.HealthOuterClass.HealthCheckResponse>
    ) {
        launch {
            tryCatchingStatus(responseObserver) {
                val response = check(request)
                onNext(response)
            }
        }
    }
    
    
    
    open fun watch(request: grpc.health.v1.HealthOuterClass.HealthCheckRequest): ReceiveChannel<grpc.health.v1.HealthOuterClass.HealthCheckResponse> {
        throw unimplemented(getWatchMethod()).asRuntimeException()
    }

    internal fun watchInternal(
        request: grpc.health.v1.HealthOuterClass.HealthCheckRequest,
        responseObserver: StreamObserver<grpc.health.v1.HealthOuterClass.HealthCheckResponse>
    ) {
        launch {
            tryCatchingStatus(responseObserver) {
                val responses = watch(request)
                for (response in responses) {
                    try {
                        onNext(response)
                    } catch (e: Throwable) {
                        responses.cancel()
                        throw e
                    }
                }
            }
        }
    }

    override fun bindService(): ServerServiceDefinition {
        return ServerServiceDefinition.builder(getServiceDescriptor())
            .addMethod(
                getCheckMethod(),
                ServerCalls.asyncUnaryCall(
                    MethodHandlers(METHODID_CHECK)
                )
            )
            .addMethod(
                getWatchMethod(),
                ServerCalls.asyncServerStreamingCall(
                    MethodHandlers(METHODID_WATCH)
                )
            )
            .build()
    }

    private fun unimplemented(methodDescriptor: MethodDescriptor<*, *>): Status {
        return Status.UNIMPLEMENTED
            .withDescription("Method ${methodDescriptor.fullMethodName} is unimplemented")
    }

    private fun <E> handleException(t: Throwable?, responseObserver: StreamObserver<E>) {
        when (t) {
            null -> return
            is CancellationException -> handleException(t.cause, responseObserver)
            is StatusException, is StatusRuntimeException -> responseObserver.onError(t)
            is RuntimeException -> {
                responseObserver.onError(Status.UNKNOWN.asRuntimeException())
                throw t
            }
            is Exception -> {
                responseObserver.onError(Status.UNKNOWN.asException())
                throw t
            }
            else -> {
                responseObserver.onError(Status.INTERNAL.asException())
                throw t
            }
        }
    }

    private suspend fun <E> tryCatchingStatus(responseObserver: StreamObserver<E>, body: suspend StreamObserver<E>.() -> Unit) {
        try {
            responseObserver.body()
            responseObserver.onCompleted()
        } catch (t: Throwable) {
            handleException(t, responseObserver)
        }
    }

    private val METHODID_CHECK = 0
    private val METHODID_WATCH = 1

    private inner class MethodHandlers<Req, Resp> internal constructor(
        private val methodId: Int
    ) : ServerCalls.UnaryMethod<Req, Resp>,
        ServerCalls.ServerStreamingMethod<Req, Resp>,
        ServerCalls.ClientStreamingMethod<Req, Resp>,
        ServerCalls.BidiStreamingMethod<Req, Resp> {

        @Suppress("UNCHECKED_CAST")
        override fun invoke(request: Req, responseObserver: StreamObserver<Resp>) {
            when (methodId) {
                METHODID_CHECK ->
                    this@HealthImplBase.checkInternal(
                        request as grpc.health.v1.HealthOuterClass.HealthCheckRequest,
                        responseObserver as StreamObserver<grpc.health.v1.HealthOuterClass.HealthCheckResponse>
                    )
                METHODID_WATCH ->
                    this@HealthImplBase.watchInternal(
                        request as grpc.health.v1.HealthOuterClass.HealthCheckRequest,
                        responseObserver as StreamObserver<grpc.health.v1.HealthOuterClass.HealthCheckResponse>
                    )
                else -> throw AssertionError()
            }
        }

        @Suppress("UNCHECKED_CAST")
        override fun invoke(responseObserver: StreamObserver<Resp>): StreamObserver<Req> {
            when (methodId) {
                else -> throw AssertionError()
            }
        }
    }
}
