package orbit.shared.proto

import orbit.shared.proto.AddressableManagementGrpc.*

import io.grpc.*
import io.grpc.stub.*
import io.rouz.grpc.*

import kotlin.coroutines.*
import kotlinx.coroutines.*
import kotlinx.coroutines.channels.*



@javax.annotation.Generated(
    value = ["by gRPC Kotlin generator"],
    comments = "Source: orbit/shared/addressable_management.proto"
)
abstract class AddressableManagementImplBase(
    coroutineContext: CoroutineContext = Dispatchers.Default
) : BindableService, CoroutineScope {

    private val _coroutineContext: CoroutineContext = coroutineContext

    override val coroutineContext: CoroutineContext
        get() = ContextCoroutineContextElement() + _coroutineContext

    
    
    
    open suspend fun renewLease(request: orbit.shared.proto.AddressableManagementOuterClass.RenewAddressableLeaseRequestProto): orbit.shared.proto.AddressableManagementOuterClass.RenewAddressableLeaseResponseProto {
        throw unimplemented(getRenewLeaseMethod()).asRuntimeException()
    }

    internal fun renewLeaseInternal(
        request: orbit.shared.proto.AddressableManagementOuterClass.RenewAddressableLeaseRequestProto,
        responseObserver: StreamObserver<orbit.shared.proto.AddressableManagementOuterClass.RenewAddressableLeaseResponseProto>
    ) {
        launch {
            tryCatchingStatus(responseObserver) {
                val response = renewLease(request)
                onNext(response)
            }
        }
    }
    
    
    
    open suspend fun abandonLease(request: orbit.shared.proto.AddressableManagementOuterClass.AbandonAddressableLeaseRequestProto): orbit.shared.proto.AddressableManagementOuterClass.AbandonAddressableLeaseResponseProto {
        throw unimplemented(getAbandonLeaseMethod()).asRuntimeException()
    }

    internal fun abandonLeaseInternal(
        request: orbit.shared.proto.AddressableManagementOuterClass.AbandonAddressableLeaseRequestProto,
        responseObserver: StreamObserver<orbit.shared.proto.AddressableManagementOuterClass.AbandonAddressableLeaseResponseProto>
    ) {
        launch {
            tryCatchingStatus(responseObserver) {
                val response = abandonLease(request)
                onNext(response)
            }
        }
    }

    override fun bindService(): ServerServiceDefinition {
        return ServerServiceDefinition.builder(getServiceDescriptor())
            .addMethod(
                getRenewLeaseMethod(),
                ServerCalls.asyncUnaryCall(
                    MethodHandlers(METHODID_RENEW_LEASE)
                )
            )
            .addMethod(
                getAbandonLeaseMethod(),
                ServerCalls.asyncUnaryCall(
                    MethodHandlers(METHODID_ABANDON_LEASE)
                )
            )
            .build()
    }

    private fun unimplemented(methodDescriptor: MethodDescriptor<*, *>): Status {
        return Status.UNIMPLEMENTED
            .withDescription("Method ${methodDescriptor.fullMethodName} is unimplemented")
    }

    private fun <E> handleException(t: Throwable?, responseObserver: StreamObserver<E>) {
        when (t) {
            null -> return
            is CancellationException -> handleException(t.cause, responseObserver)
            is StatusException, is StatusRuntimeException -> responseObserver.onError(t)
            is RuntimeException -> {
                responseObserver.onError(Status.UNKNOWN.asRuntimeException())
                throw t
            }
            is Exception -> {
                responseObserver.onError(Status.UNKNOWN.asException())
                throw t
            }
            else -> {
                responseObserver.onError(Status.INTERNAL.asException())
                throw t
            }
        }
    }

    private suspend fun <E> tryCatchingStatus(responseObserver: StreamObserver<E>, body: suspend StreamObserver<E>.() -> Unit) {
        try {
            responseObserver.body()
            responseObserver.onCompleted()
        } catch (t: Throwable) {
            handleException(t, responseObserver)
        }
    }

    private val METHODID_RENEW_LEASE = 0
    private val METHODID_ABANDON_LEASE = 1

    private inner class MethodHandlers<Req, Resp> internal constructor(
        private val methodId: Int
    ) : ServerCalls.UnaryMethod<Req, Resp>,
        ServerCalls.ServerStreamingMethod<Req, Resp>,
        ServerCalls.ClientStreamingMethod<Req, Resp>,
        ServerCalls.BidiStreamingMethod<Req, Resp> {

        @Suppress("UNCHECKED_CAST")
        override fun invoke(request: Req, responseObserver: StreamObserver<Resp>) {
            when (methodId) {
                METHODID_RENEW_LEASE ->
                    this@AddressableManagementImplBase.renewLeaseInternal(
                        request as orbit.shared.proto.AddressableManagementOuterClass.RenewAddressableLeaseRequestProto,
                        responseObserver as StreamObserver<orbit.shared.proto.AddressableManagementOuterClass.RenewAddressableLeaseResponseProto>
                    )
                METHODID_ABANDON_LEASE ->
                    this@AddressableManagementImplBase.abandonLeaseInternal(
                        request as orbit.shared.proto.AddressableManagementOuterClass.AbandonAddressableLeaseRequestProto,
                        responseObserver as StreamObserver<orbit.shared.proto.AddressableManagementOuterClass.AbandonAddressableLeaseResponseProto>
                    )
                else -> throw AssertionError()
            }
        }

        @Suppress("UNCHECKED_CAST")
        override fun invoke(responseObserver: StreamObserver<Resp>): StreamObserver<Req> {
            when (methodId) {
                else -> throw AssertionError()
            }
        }
    }
}
