package grpc.health.v1

import io.rouz.grpc.*
import grpc.health.v1.HealthGrpc.HealthStub

import kotlinx.coroutines.channels.ReceiveChannel
import kotlin.coroutines.suspendCoroutine

import io.grpc.Metadata
import io.grpc.stub.MetadataUtils

/**
 * Kotlin extension functions for [grpc.health.v1.HealthGrpc.HealthStub]
 *
 * Generated by gRPC Kotlin generator
 * Source: orbit/shared/health.proto
 */




suspend inline fun HealthStub.check(request: grpc.health.v1.HealthOuterClass.HealthCheckRequest): grpc.health.v1.HealthOuterClass.HealthCheckResponse {
    return suspendCoroutine {
        check(request, ContinuationStreamObserver(it))
    }
}



fun HealthStub.watch(request: grpc.health.v1.HealthOuterClass.HealthCheckRequest): ReceiveChannel<grpc.health.v1.HealthOuterClass.HealthCheckResponse> {
    val responseChannel = StreamObserverChannel<grpc.health.v1.HealthOuterClass.HealthCheckResponse>()
    watch(request, responseChannel)
    return responseChannel
}

/**
* Adds new binary header and returns the client
*/
fun HealthStub.addBinaryHeader(
    header: String,
    bytes: ByteArray
): HealthStub {
    val headers = Metadata()
    val key = Metadata.Key.of(header, Metadata.BINARY_BYTE_MARSHALLER)
    headers.put(key, bytes)

    return MetadataUtils.attachHeaders(this, headers)
}
