/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.json;

import cloud.orbit.actors.Actor;
import cloud.orbit.actors.ActorObserver;
import cloud.orbit.actors.cluster.NodeAddress;
import cloud.orbit.actors.cluster.NodeAddressImpl;
import cloud.orbit.actors.runtime.AbstractActor;
import cloud.orbit.actors.runtime.DescriptorFactory;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.exception.UncheckedException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import java.io.IOException;
import java.util.UUID;

public class ActorReferenceModule
extends Module {
    private static final Version MODULE_VERSION = new Version(1, 0, 0, "", "cloud.orbit.actors", "json");
    private DescriptorFactory descriptorFactory;

    public ActorReferenceModule() {
    }

    public ActorReferenceModule(DescriptorFactory descriptorFactory) {
        this.descriptorFactory = descriptorFactory;
    }

    public String getModuleName() {
        return "orbit-actor-reference";
    }

    public Version version() {
        return MODULE_VERSION;
    }

    public void setupModule(Module.SetupContext context) {
        context.addDeserializers((Deserializers)new Deserializers.Base(){

            public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) {
                Class rawClass = type.getRawClass();
                if (Actor.class.isAssignableFrom(rawClass)) {
                    return new RefDeserializer(rawClass, ActorReferenceModule.this.descriptorFactory);
                }
                if (ActorObserver.class.isAssignableFrom(rawClass)) {
                    return new ObserverRefDeserializer(rawClass, ActorReferenceModule.this.descriptorFactory);
                }
                return null;
            }
        });
        context.addSerializers((Serializers)new Serializers.Base(){

            public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
                Class rawClass = type.getRawClass();
                if (Actor.class.isAssignableFrom(rawClass)) {
                    return new RefSerializer(rawClass);
                }
                if (ActorObserver.class.isAssignableFrom(rawClass)) {
                    return new ObserverRefSerializer();
                }
                return null;
            }
        });
    }

    public DescriptorFactory getDescriptorFactory() {
        return this.descriptorFactory;
    }

    public void setDescriptorFactory(DescriptorFactory descriptorFactory) {
        this.descriptorFactory = descriptorFactory;
    }

    private static class ObserverRefDeserializer
    extends JsonDeserializer<Object> {
        private final Class<?> iClass;
        private final DescriptorFactory factory;

        public ObserverRefDeserializer(Class<?> iClass, DescriptorFactory factory) {
            this.iClass = iClass;
            this.factory = factory;
        }

        public Object deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            String text = jsonParser.getText();
            int idx = text.indexOf(47);
            if (idx != 0) {
                UUID uuid = UUID.fromString(text.substring(0, idx));
                return this.factory.getReference((NodeAddress)new NodeAddressImpl(uuid), this.iClass, (Object)text.substring(idx + 1));
            }
            return this.factory.getReference(null, this.iClass, (Object)text.substring(idx + 1));
        }

        public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            return this.deserialize(p, ctxt);
        }
    }

    private static class RefDeserializer
    extends JsonDeserializer<Object> {
        private final Class<?> iClass;
        private final DescriptorFactory factory;

        public RefDeserializer(Class<?> iClass, DescriptorFactory factory) {
            this.iClass = iClass;
            this.factory = factory;
        }

        public Object deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            String text = jsonParser.getText();
            if (text != null && text.startsWith("!!")) {
                if (text.startsWith("!!!")) {
                    return this.factory.getReference(null, this.iClass, (Object)text.substring(1));
                }
                int idx = text.indexOf(32);
                String className = text.substring(2, idx);
                String key = text.substring(idx + 1);
                try {
                    Class<?> aClass = Class.forName(className);
                    return this.factory.getReference(null, aClass, (Object)key);
                }
                catch (ClassNotFoundException e) {
                    throw new UncheckedException("Can't find class: " + e);
                }
            }
            return this.factory.getReference(null, this.iClass, (Object)text);
        }

        public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            return this.deserialize(p, ctxt);
        }
    }

    private static class ObserverRefSerializer
    extends JsonSerializer<Object> {
        private ObserverRefSerializer() {
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            NodeAddress address = RemoteReference.getAddress((RemoteReference)((RemoteReference)value));
            Object actorId = RemoteReference.getId((RemoteReference)((RemoteReference)value));
            jgen.writeString((address != null ? address.asUUID() : "") + "/" + actorId);
        }

        public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            this.serialize(value, gen, serializers);
        }
    }

    private static class RefSerializer
    extends JsonSerializer<Object>
    implements ContextualSerializer {
        private final Class<?> rawClass;

        public RefSerializer(Class<?> rawClass) {
            this.rawClass = rawClass != null && rawClass.isInterface() && Actor.class.isAssignableFrom(rawClass) ? rawClass : null;
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            RemoteReference reference = (RemoteReference)(value instanceof AbstractActor ? RemoteReference.from((AbstractActor)((AbstractActor)value)) : value);
            String text = String.valueOf(RemoteReference.getId((RemoteReference)reference));
            Class interfaceClass = RemoteReference.getInterfaceClass((RemoteReference)reference);
            if (interfaceClass != null && interfaceClass == this.rawClass) {
                if (!text.startsWith("!!")) {
                    jgen.writeString(text);
                } else {
                    jgen.writeString("!" + text);
                }
            } else {
                if (interfaceClass != null && this.rawClass == null) {
                    throw new IOException("Illegal json serialization of actor reference " + interfaceClass + ":" + text + " won't be able to deserialize later");
                }
                jgen.writeString("!!" + interfaceClass.getName() + " " + text);
            }
        }

        public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            this.serialize(value, gen, serializers);
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            JavaType type;
            if (property != null && (type = property.getType()) != null) {
                Class clazz = type.getRawClass();
                if (type.isCollectionLikeType()) {
                    return new RefSerializer(type.getContentType().getRawClass());
                }
                if (type.isMapLikeType()) {
                    return new RefSerializer(type.getContentType().getRawClass());
                }
                if (clazz != null) {
                    return new RefSerializer(clazz);
                }
            }
            return this;
        }
    }
}

