/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.json;

import cloud.orbit.actors.extensions.MessageSerializer;
import cloud.orbit.actors.extensions.json.ActorReferenceModule;
import cloud.orbit.actors.extensions.json.ClassIdTypeResolverBuilder;
import cloud.orbit.actors.runtime.BasicRuntime;
import cloud.orbit.actors.runtime.DefaultDescriptorFactory;
import cloud.orbit.actors.runtime.DescriptorFactory;
import cloud.orbit.actors.runtime.Message;
import cloud.orbit.actors.runtime.ObjectInvoker;
import cloud.orbit.exception.UncheckedException;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

public class JsonMessageSerializer
implements MessageSerializer {
    private final ObjectMapper mapper = new ObjectMapper();
    private final ActorReferenceModule actorReferenceModule = new ActorReferenceModule(DefaultDescriptorFactory.get());
    private BasicRuntime runtime;

    public JsonMessageSerializer() {
        this.mapper.registerModule((Module)this.actorReferenceModule);
        this.mapper.setVisibility(this.mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ClassIdTypeResolverBuilder typer = new ClassIdTypeResolverBuilder(ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT);
        typer = typer.init(JsonTypeInfo.Id.NAME, null);
        typer = typer.inclusion(JsonTypeInfo.As.PROPERTY);
        this.mapper.setDefaultTyping((TypeResolverBuilder)typer);
    }

    public Message deserializeMessage(BasicRuntime runtime, byte[] payload) throws Exception {
        this.ensureInit(runtime);
        Message message = (Message)this.mapper.readValue(payload, Message.class);
        if (message.getPayload() != null && (message.getMessageType() == 0 || message.getMessageType() == 1)) {
            ObjectInvoker invoker = runtime.getInvoker(message.getInterfaceId());
            Method method = invoker.getMethod(message.getMethodId());
            Object[] args = this.castArgs(method.getGenericParameterTypes(), message.getPayload());
            message.setPayload((Object)args);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInit(BasicRuntime newRuntime) {
        if (this.runtime == null && newRuntime != null) {
            ActorReferenceModule actorReferenceModule = this.actorReferenceModule;
            synchronized (actorReferenceModule) {
                if (this.runtime == null) {
                    this.actorReferenceModule.setDescriptorFactory((DescriptorFactory)newRuntime);
                    this.runtime = newRuntime;
                }
            }
        }
    }

    public byte[] serializeMessage(BasicRuntime runtime, Message message) throws Exception {
        this.ensureInit(runtime);
        if (message.getPayload() instanceof Throwable && message.getMessageType() == 3) {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                ((Throwable)message.getPayload()).printStackTrace(pw);
                pw.flush();
            }
            message.withPayload((Object)sw.toString());
        }
        if (message.getHeaders() != null && message.getHeaders().size() == 0) {
            message.setHeaders(null);
        }
        return this.mapper.writeValueAsBytes((Object)message);
    }

    private Object[] castArgs(Type[] genericParameterTypes, Object payload) {
        Object[] args0 = payload instanceof List ? ((List)payload).toArray() : (Object[])payload;
        Object[] casted = new Object[genericParameterTypes.length];
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            casted[i] = this.convertValue(args0[i], genericParameterTypes[i]);
        }
        return casted;
    }

    private Object convertValue(Object o, Type genericParameterType) {
        if (o == null || genericParameterType == o.getClass() || genericParameterType == Object.class) {
            return o;
        }
        if (genericParameterType == String.class) {
            return String.valueOf(o);
        }
        if ((genericParameterType == Integer.TYPE || genericParameterType == Integer.class) && o instanceof Number) {
            return ((Number)o).intValue();
        }
        if ((genericParameterType == Long.TYPE || genericParameterType == Long.class) && o instanceof Number) {
            return ((Number)o).longValue();
        }
        try {
            return this.mapper.convertValue(o, this.mapper.constructType(genericParameterType));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new UncheckedException(ex);
        }
    }
}

