/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.json;

import cloud.orbit.actors.extensions.json.ClassIdAsPropertyTypeDeserializer;
import cloud.orbit.actors.extensions.json.ClassIdAsPropertyTypeSerializer;
import cloud.orbit.actors.extensions.json.ClassIdResolver;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.lang.reflect.Type;
import java.util.Collection;

class ClassIdTypeResolverBuilder
extends ObjectMapper.DefaultTypeResolverBuilder {
    public ClassIdTypeResolverBuilder(ObjectMapper.DefaultTyping typing) {
        super(typing);
    }

    public boolean useForType(JavaType t) {
        if (t.isCollectionLikeType()) {
            return false;
        }
        return super.useForType(t);
    }

    protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        if (this._idType == null) {
            throw new IllegalStateException("Can not build, 'init()' not yet called");
        }
        switch (this._idType) {
            case CUSTOM: 
            case NAME: {
                return new ClassIdResolver(baseType, config);
            }
        }
        return super.idResolver(config, baseType, subtypes, forSer, forDeser);
    }

    public TypeDeserializer buildTypeDeserializer(DeserializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        if (!this.useForType(baseType)) {
            return null;
        }
        if (this._idType == JsonTypeInfo.Id.NONE) {
            return null;
        }
        TypeIdResolver idRes = this.idResolver((MapperConfig<?>)config, baseType, subtypes, false, true);
        JavaType defaultImpl = this._defaultImpl == null ? null : (this._defaultImpl == Void.class || this._defaultImpl == NoClass.class ? config.getTypeFactory().constructType((Type)this._defaultImpl) : config.getTypeFactory().constructSpecializedType(baseType, this._defaultImpl));
        switch (this._includeAs) {
            case PROPERTY: 
            case EXISTING_PROPERTY: {
                return new ClassIdAsPropertyTypeDeserializer(baseType, idRes, this._typeProperty, this._typeIdVisible, defaultImpl, this._includeAs);
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type serializer for inclusion type: " + this._includeAs);
    }

    public TypeSerializer buildTypeSerializer(SerializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        if (!this.useForType(baseType)) {
            return null;
        }
        if (this._idType == JsonTypeInfo.Id.NONE) {
            return null;
        }
        TypeIdResolver idRes = this.idResolver((MapperConfig<?>)config, baseType, subtypes, true, false);
        switch (this._includeAs) {
            case PROPERTY: 
            case EXISTING_PROPERTY: {
                return new ClassIdAsPropertyTypeSerializer(idRes, this._typeProperty);
            }
        }
        return super.buildTypeSerializer(config, baseType, subtypes);
    }
}

