/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.json;

import cloud.orbit.actors.runtime.DefaultClassDictionary;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.ArrayList;

class ClassIdAsPropertyTypeDeserializer
extends AsPropertyTypeDeserializer {
    public ClassIdAsPropertyTypeDeserializer(AsPropertyTypeDeserializer src, BeanProperty property) {
        super(src, property);
    }

    public ClassIdAsPropertyTypeDeserializer(JavaType baseType, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl, JsonTypeInfo.As inclusion) {
        super(baseType, idRes, typePropertyName, typeIdVisible, defaultImpl, inclusion);
    }

    public TypeDeserializer forProperty(BeanProperty prop) {
        return prop == this._property ? this : new ClassIdAsPropertyTypeDeserializer(this, prop);
    }

    protected String _locateTypeId(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (!jp.isExpectedStartArrayToken()) {
            if (this._defaultImpl != null) {
                return this._idResolver.idFromBaseType();
            }
            throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "Missing type information for: " + this.baseTypeName());
        }
        return String.valueOf(DefaultClassDictionary.get().getClassId(ArrayList.class));
    }

    protected Object _deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Object typeId;
        if (jp.canReadTypeId() && (typeId = jp.getTypeId()) != null) {
            return this._deserializeWithNativeTypeId(jp, ctxt, typeId);
        }
        typeId = this._locateTypeId(jp, ctxt);
        JsonDeserializer deser = this._findDeserializer(ctxt, (String)typeId);
        if (this._typeIdVisible && !this._usesExternalId() && jp.getCurrentToken() == JsonToken.START_OBJECT) {
            TokenBuffer tb = new TokenBuffer(null, false);
            tb.writeStartObject();
            tb.writeFieldName(this._typePropertyName);
            tb.writeString((String)typeId);
            jp = JsonParserSequence.createFlattened((JsonParser)tb.asParser(jp), (JsonParser)jp);
            jp.nextToken();
        }
        Object value = deser.deserialize(jp, ctxt);
        return value;
    }
}

