/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.json;

import cloud.orbit.actors.runtime.DefaultClassDictionary;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Collection;
import java.util.Map;

class ClassIdResolver
extends ClassNameIdResolver {
    public ClassIdResolver(JavaType baseType, MapperConfig<?> config) {
        super(baseType, config.getTypeFactory());
    }

    public String idFromValue(Object value) {
        return this.idFromValueAndType(value, value.getClass());
    }

    public String idFromValueAndType(Object value, Class<?> type) {
        int id = this.intIdFromValueAndType(value, type);
        return id != 0 ? String.valueOf(id) : null;
    }

    public int intIdFromValueAndType(Object value, Class<?> type) {
        if (type != null && type.isArray()) {
            return 0;
        }
        if (value != null) {
            if (value.getClass().isArray() || value instanceof Collection || value instanceof Map) {
                return 0;
            }
            return DefaultClassDictionary.get().getClassId(value.getClass());
        }
        return DefaultClassDictionary.get().getClassId(type);
    }

    protected JavaType _typeFromId(String id, TypeFactory typeFactory) {
        Class cls = DefaultClassDictionary.get().getClassById(Integer.parseInt(id));
        return typeFactory.constructSpecializedType(this._baseType, cls);
    }
}

