/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.json;

import cloud.orbit.actors.extensions.StorageExtension;
import cloud.orbit.actors.extensions.json.ActorReferenceModule;
import cloud.orbit.actors.runtime.DefaultDescriptorFactory;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.concurrent.Task;
import cloud.orbit.exception.UncheckedException;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InMemoryJSONStorageExtension
implements StorageExtension {
    private ConcurrentMap<Object, Object> database;
    private ObjectMapper mapper = new ObjectMapper();
    private String name;

    public String getName() {
        return this.name;
    }

    public InMemoryJSONStorageExtension() {
        this(new ConcurrentHashMap<Object, Object>());
    }

    public InMemoryJSONStorageExtension(ConcurrentMap<Object, Object> database) {
        this("default", database);
    }

    public InMemoryJSONStorageExtension(String name, ConcurrentMap<Object, Object> database) {
        this.name = name;
        this.database = database;
        this.mapper.registerModule((Module)new ActorReferenceModule(DefaultDescriptorFactory.get()));
        this.mapper.enableDefaultTyping();
        this.mapper.setVisibility(this.mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
    }

    public Task<Void> clearState(RemoteReference<?> reference, Object state) {
        this.database.remove(reference);
        return Task.done();
    }

    public Task<Void> stop() {
        return Task.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Boolean> readState(RemoteReference<?> reference, Object state) {
        String databaseObject = (String)this.database.get(reference);
        if (databaseObject != null) {
            InMemoryJSONStorageExtension inMemoryJSONStorageExtension = this;
            synchronized (inMemoryJSONStorageExtension) {
                try {
                    this.mapper.readerForUpdating(state).readValue(databaseObject);
                }
                catch (IOException e) {
                    throw new UncheckedException((Throwable)e);
                }
            }
        }
        return Task.fromValue((Object)(databaseObject != null ? 1 : 0));
    }

    public Task<Void> writeState(RemoteReference<?> reference, Object state) {
        try {
            this.database.put(reference, this.mapper.writeValueAsString(state));
        }
        catch (JsonProcessingException e) {
            throw new UncheckedException((Throwable)e);
        }
        return Task.done();
    }
}

