/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.web;

import cloud.orbit.annotation.Config;
import cloud.orbit.concurrent.Task;
import cloud.orbit.container.Container;
import cloud.orbit.exception.UncheckedException;
import cloud.orbit.lifecycle.Startable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EmbeddedJettyServer
implements Startable {
    @Inject
    Container container;
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedJettyServer.class);
    private Server server;
    @Config(value="orbit.jetty.port")
    private int port = 9090;
    @Config(value="orbit.jetty.requestHeaderSize")
    private Integer requestHeaderSize = null;
    @Config(value="orbit.jetty.responseHeaderSize")
    private Integer responseHeaderSize = null;
    @Config(value="orbit.jetty.outputBufferSize")
    private Integer outputBufferSize = null;
    @Config(value="orbit.jetty.ssl.enabled")
    private boolean enableSSL = false;
    @Config(value="orbit.jetty.ssl.keyStore.path")
    private String sslKeyStorePath = null;
    @Config(value="orbit.jetty.ssl.keyStore.password")
    private String sslKeyStorePassword = null;
    @Config(value="orbit.jetty.ssl.keyManager.password")
    private String sslKeyManagerPassword = null;
    @Config(value="orbit.jetty.ssl.trustStore.path")
    private String sslTrustStorePath = null;
    @Config(value="orbit.jetty.ssl.trustStore.password")
    private String sslTrustStorePassword = null;
    @Config(value="orbit.jetty.ssl.cipherSuites.include")
    private List<String> sslIncludedCipherSuites = null;
    @Config(value="orbit.jetty.ssl.cipherSuites.exclude")
    private List<String> sslExcludedCipherSuites = null;
    @Config(value="orbit.jetty.ssl.clientAuth.enabled")
    private boolean clientAuth = false;
    @Config(value="orbit.jetty.ssl.protocols.include")
    private List<String> sslIncludedProtocols = null;
    @Config(value="orbit.jetty.ssl.protocols.exclude")
    private List<String> sslExcludedProtocols = null;

    public Task start() {
        logger.info("Starting Jetty server...");
        List classes = this.container.getDiscoveredClasses();
        ResourceConfig resourceConfig = new ResourceConfig();
        classes.stream().filter(r -> (r.isAnnotationPresent(Path.class) || r.isAnnotationPresent(Provider.class)) && !r.isAnnotationPresent(ServerEndpoint.class) && !Servlet.class.isAssignableFrom((Class<?>)r)).forEach(arg_0 -> ((ResourceConfig)resourceConfig).register(arg_0));
        WebAppContext webAppContext = new WebAppContext();
        ProtectionDomain protectionDomain = EmbeddedJettyServer.class.getProtectionDomain();
        URL location = protectionDomain.getCodeSource().getLocation();
        logger.info(location.toExternalForm());
        webAppContext.setInitParameter("useFileMappedBuffer", "false");
        webAppContext.setWar(location.toExternalForm());
        webAppContext.getServletContext().setAttribute("jersey.config.servlet.context.serviceLocator", (Object)this.container.getServiceLocator());
        webAppContext.setContextPath("/");
        webAppContext.addServlet(new ServletHolder((Servlet)new ServletContainer(resourceConfig)), "/*");
        ContextHandler resourceContext = new ContextHandler();
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setWelcomeFiles(new String[]{"index.html"});
        resourceHandler.setBaseResource(Resource.newClassPathResource((String)"/web"));
        resourceContext.setHandler((Handler)resourceHandler);
        resourceContext.setInitParameter("useFileMappedBuffer", "false");
        classes.stream().filter(r -> r.isAnnotationPresent(Path.class) && Servlet.class.isAssignableFrom((Class<?>)r)).forEach(r -> {
            Path path = r.getAnnotation(Path.class);
            webAppContext.addServlet(r, path.value());
            resourceConfig.register(r);
        });
        ArrayList<Object> handlers = new ArrayList<Object>(3);
        handlers.add(resourceContext);
        handlers.add(webAppContext);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(handlers.toArray(new Handler[handlers.size()]));
        this.server = new Server();
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        if (this.requestHeaderSize != null) {
            httpConfiguration.setRequestHeaderSize(this.requestHeaderSize.intValue());
        }
        if (this.responseHeaderSize != null) {
            httpConfiguration.setResponseHeaderSize(this.responseHeaderSize.intValue());
        }
        if (this.outputBufferSize != null) {
            httpConfiguration.setOutputBufferSize(this.outputBufferSize.intValue());
        }
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        if (this.enableSSL) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setNeedClientAuth(this.clientAuth);
            if (this.sslKeyStorePath != null) {
                sslContextFactory.setKeyStorePath(this.sslKeyStorePath);
            }
            if (this.sslKeyStorePassword != null) {
                sslContextFactory.setKeyStorePassword(this.sslKeyStorePassword);
            }
            if (this.sslKeyManagerPassword != null) {
                sslContextFactory.setKeyManagerPassword(this.sslKeyManagerPassword);
            }
            if (this.sslTrustStorePath != null) {
                sslContextFactory.setTrustStorePath(this.sslTrustStorePath);
            }
            if (this.sslTrustStorePassword != null) {
                sslContextFactory.setTrustStorePassword(this.sslTrustStorePassword);
            }
            if (this.sslIncludedCipherSuites != null) {
                sslContextFactory.setIncludeCipherSuites(this.sslIncludedCipherSuites.toArray(new String[this.sslIncludedCipherSuites.size()]));
            }
            if (this.sslExcludedCipherSuites != null) {
                sslContextFactory.setExcludeCipherSuites(this.sslExcludedCipherSuites.toArray(new String[this.sslExcludedCipherSuites.size()]));
            }
            if (this.sslIncludedProtocols != null) {
                sslContextFactory.setIncludeProtocols(this.sslIncludedProtocols.toArray(new String[this.sslIncludedProtocols.size()]));
            }
            if (this.sslExcludedProtocols != null) {
                sslContextFactory.setExcludeProtocols(this.sslExcludedProtocols.toArray(new String[this.sslExcludedProtocols.size()]));
            }
            HttpConfiguration httpsConfiguration = new HttpConfiguration(httpConfiguration);
            httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector sslConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfiguration)});
            sslConnector.setPort(this.port);
            connectors.add(sslConnector);
        } else {
            HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
            ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{httpConnectionFactory});
            connector.setPort(this.port);
            connectors.add(connector);
        }
        ServerConnector[] actualList = new ServerConnector[connectors.size()];
        actualList = connectors.toArray(actualList);
        this.server.setConnectors((Connector[])actualList);
        this.server.setHandler((Handler)contexts);
        try {
            ServerContainer serverContainer = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)webAppContext);
            classes.stream().filter(r -> r.isAnnotationPresent(ServerEndpoint.class)).forEach(r -> {
                ServerEndpoint annotation = r.getAnnotation(ServerEndpoint.class);
                ServerEndpointConfig serverEndpointConfig = ServerEndpointConfig.Builder.create((Class)r, (String)annotation.value()).configurator(new ServerEndpointConfig.Configurator(){

                    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
                        Object instance = EmbeddedJettyServer.this.container.getServiceLocator().getService(endpointClass, new Annotation[0]);
                        if (instance == null) {
                            try {
                                instance = endpointClass.newInstance();
                            }
                            catch (Exception e) {
                                throw new UncheckedException((Throwable)e);
                            }
                        }
                        return (T)instance;
                    }
                }).build();
                try {
                    serverContainer.addEndpoint(serverEndpointConfig);
                }
                catch (Exception e) {
                    throw new UncheckedException((Throwable)e);
                }
            });
        }
        catch (Exception e) {
            logger.error("Error starting jetty: " + e.toString());
            throw new UncheckedException((Throwable)e);
        }
        try {
            this.server.start();
        }
        catch (Exception e) {
            logger.error("Error starting jetty: " + e.toString());
            throw new UncheckedException((Throwable)e);
        }
        logger.info("Jetty server started.");
        return Task.done();
    }

    public Task stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.error("Error stopping jetty: " + e.toString());
            throw new UncheckedException((Throwable)e);
        }
        return Task.done();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

