/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster;

import cloud.orbit.actors.cluster.ExtendedClusterPeer;
import cloud.orbit.actors.cluster.MessageListener;
import cloud.orbit.actors.cluster.NodeAddress;
import cloud.orbit.actors.cluster.NodeAddressImpl;
import cloud.orbit.actors.cluster.ViewListener;
import cloud.orbit.concurrent.Task;
import cloud.orbit.exception.UncheckedException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinTask;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.fork.ForkChannel;
import org.jgroups.protocols.FRAG2;
import org.jgroups.protocols.FRAG3;
import org.jgroups.protocols.UDP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.MessageBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsClusterPeer
implements ExtendedClusterPeer {
    private static final Logger logger = LoggerFactory.getLogger(JGroupsClusterPeer.class);
    private static final String REPLICATED_CONFIGURATION_NAME = "replicatedAsyncCache";
    private final Executor executor;
    private int portRangeLength = 1000;
    private Task<Address> startFuture;
    private ForkChannel channel;
    private DefaultCacheManager cacheManager;
    private NodeInfo local;
    private NodeInfo master;
    private final Map<Address, NodeInfo> nodeMap = new ConcurrentHashMap<Address, NodeInfo>();
    private final Map<NodeAddress, NodeInfo> nodeMap2 = new ConcurrentHashMap<NodeAddress, NodeInfo>();
    private ViewListener viewListener;
    private MessageListener messageListener;
    private String jgroupsConfig = "classpath:/conf/udp-jgroups.xml";
    private boolean nameBasedUpdPort = true;

    public JGroupsClusterPeer() {
        this(Runnable::run);
    }

    public JGroupsClusterPeer(Executor executor) {
        this.executor = executor;
    }

    public NodeAddress localAddress() {
        this.sync();
        return this.local.nodeAddress;
    }

    public void registerViewListener(ViewListener viewListener) {
        this.viewListener = viewListener;
    }

    public void registerMessageReceiver(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public Task<?> join(String clusterName, String nodeName) {
        ForkJoinTask<Address> f = ForkJoinTask.adapt(() -> {
            try {
                ProtocolStack stack;
                if (System.getProperty("java.net.preferIPv4Stack", null) == null) {
                    System.setProperty("java.net.preferIPv4Stack", "true");
                }
                JChannel baseChannel = new JChannel(this.configToURL(this.getJgroupsConfig()));
                baseChannel.setName(nodeName);
                if (this.isNameBasedUpdPort() && baseChannel.getProtocolStack().getBottomProtocol() instanceof UDP) {
                    UDP udp = (UDP)baseChannel.getProtocolStack().getBottomProtocol();
                    udp.setMulticastPort(udp.getMulticastPort() + (clusterName.hashCode() & 0x8FFFFFFF) % this.portRangeLength);
                }
                Class neighborProtocol = (stack = baseChannel.getProtocolStack()).findProtocol(FRAG2.class) != null ? FRAG2.class : FRAG3.class;
                this.channel = new ForkChannel(baseChannel, "hijack-stack", "lead-hijacker", true, ProtocolStack.Position.ABOVE, neighborProtocol, new Protocol[0]);
                this.channel.setReceiver((Receiver)new ReceiverAdapter(){

                    public void viewAccepted(View view) {
                        JGroupsClusterPeer.this.doViewAccepted(view);
                    }

                    public void receive(MessageBatch batch) {
                        Task.runAsync(() -> {
                            for (Message message : batch) {
                                try {
                                    JGroupsClusterPeer.this.doReceive(message);
                                }
                                catch (Throwable ex) {
                                    logger.error("Error receiving batched message", ex);
                                }
                            }
                        }, (Executor)JGroupsClusterPeer.this.executor).exceptionally(e -> {
                            logger.error("Error receiving message", e);
                            return null;
                        });
                    }

                    public void receive(Message msg) {
                        Task.runAsync(() -> JGroupsClusterPeer.this.doReceive(msg), (Executor)JGroupsClusterPeer.this.executor).exceptionally(e -> {
                            logger.error("Error receiving message", e);
                            return null;
                        });
                    }
                });
                GlobalConfigurationBuilder globalConfigurationBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
                globalConfigurationBuilder.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true));
                globalConfigurationBuilder.transport().clusterName(clusterName).nodeName(nodeName).transport((Transport)new JGroupsTransport(baseChannel));
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.clustering().cacheMode(CacheMode.DIST_ASYNC);
                this.cacheManager = new DefaultCacheManager(globalConfigurationBuilder.build(), builder.build());
                ConfigurationBuilder builder2 = new ConfigurationBuilder();
                builder2.clustering().cacheMode(CacheMode.REPL_ASYNC);
                this.cacheManager.defineConfiguration(REPLICATED_CONFIGURATION_NAME, builder2.build());
                this.cacheManager.getCache("distributedDirectory");
                this.channel.connect(clusterName);
                this.local = new NodeInfo(this.channel.getAddress());
                logger.info("Registering the local address");
                logger.info("Done with JGroups initialization");
                return this.local.address;
            }
            catch (Exception e) {
                logger.error("Error during JGroups initialization", (Throwable)e);
                throw new UncheckedException((Throwable)e);
            }
        });
        this.startFuture = Task.fromFuture(f);
        f.fork();
        return this.startFuture;
    }

    private URL configToURL(String jgroupsConfig) throws MalformedURLException {
        if (jgroupsConfig.startsWith("classpath:")) {
            String resourcePath = jgroupsConfig.substring("classpath:".length());
            URL resource = this.getClass().getResource(resourcePath);
            if (resource == null) {
                throw new IllegalArgumentException("Can't find classpath resource: " + resourcePath);
            }
            return resource;
        }
        if (!jgroupsConfig.contains(":")) {
            return Paths.get(jgroupsConfig, new String[0]).toUri().toURL();
        }
        return new URL(jgroupsConfig);
    }

    public void leave() {
        this.channel.close();
        this.channel = null;
        this.cacheManager.stop();
    }

    private void sync() {
        if (this.startFuture != null && !this.startFuture.isDone()) {
            this.startFuture.join();
        }
    }

    private void doViewAccepted(View view) {
        ConcurrentHashMap<Address, NodeInfo> newNodes = new ConcurrentHashMap<Address, NodeInfo>(view.size());
        ConcurrentHashMap<NodeAddress, NodeInfo> newNodes2 = new ConcurrentHashMap<NodeAddress, NodeInfo>(view.size());
        for (Address a : view) {
            NodeInfo info = this.nodeMap.get(a);
            if (info == null) {
                info = new NodeInfo(a);
            }
            newNodes.put(a, info);
            newNodes2.put(info.nodeAddress, info);
        }
        NodeInfo newMaster = (NodeInfo)newNodes.values().iterator().next();
        this.nodeMap.putAll(newNodes);
        this.nodeMap.values().retainAll(newNodes.values());
        this.nodeMap2.putAll(newNodes2);
        this.nodeMap2.values().retainAll(newNodes2.values());
        this.master = newMaster;
        this.viewListener.onViewChange(this.nodeMap2.keySet());
    }

    public void sendMessage(NodeAddress address, byte[] message) {
        try {
            NodeInfo node = this.nodeMap2.get(Objects.requireNonNull(address, "node address"));
            if (node == null) {
                throw new IllegalArgumentException("Cluster node not found: " + address);
            }
            ForkChannel channel = this.channel;
            if (channel == null || !channel.isOpen()) {
                throw new IllegalStateException("Cluster not connected");
            }
            channel.send(node.address, message);
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    @Override
    public <K, V> ConcurrentMap<K, V> getCache(String name) {
        return this.cacheManager.getCache(name);
    }

    @Override
    public <K, V> ConcurrentMap<K, V> getReplicatedCache(String name) {
        return this.cacheManager.getCache(name, REPLICATED_CONFIGURATION_NAME);
    }

    private void doReceive(Message msg) {
        NodeInfo nodeInfo = this.nodeMap.get(msg.getSrc());
        if (nodeInfo == null) {
            logger.warn("Received message from invalid address {}", (Object)msg.getSrc());
            this.messageListener.receive((NodeAddress)new NodeAddressImpl(new UUID(((org.jgroups.util.UUID)msg.getSrc()).getMostSignificantBits(), ((org.jgroups.util.UUID)msg.getSrc()).getLeastSignificantBits())), msg.getBuffer());
        } else {
            this.messageListener.receive(nodeInfo.nodeAddress, msg.getBuffer());
        }
    }

    public NodeAddress getMaster() {
        return this.master != null ? this.master.nodeAddress : null;
    }

    public String getJgroupsConfig() {
        return this.jgroupsConfig;
    }

    public void setJgroupsConfig(String jgroupsConfig) {
        this.jgroupsConfig = jgroupsConfig;
    }

    public boolean isNameBasedUpdPort() {
        return this.nameBasedUpdPort;
    }

    public void setNameBasedUpdPort(boolean nameBasedUpdPort) {
        this.nameBasedUpdPort = nameBasedUpdPort;
    }

    public int getPortRangeLength() {
        return this.portRangeLength;
    }

    public void setPortRangeLength(int portRangeLength) {
        this.portRangeLength = portRangeLength;
    }

    private static final class NodeInfo {
        private final Address address;
        private final NodeAddress nodeAddress;

        NodeInfo(Address address) {
            this.address = address;
            org.jgroups.util.UUID jgroupsUUID = (org.jgroups.util.UUID)address;
            this.nodeAddress = new NodeAddressImpl(new UUID(jgroupsUUID.getMostSignificantBits(), jgroupsUUID.getLeastSignificantBits()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeInfo nodeInfo = (NodeInfo)o;
            return this.address.equals(nodeInfo.address);
        }

        public int hashCode() {
            return this.address.hashCode();
        }
    }
}

