/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.cluster;

import cloud.orbit.actors.cluster.ClusterPeer;
import cloud.orbit.actors.cluster.MessageListener;
import cloud.orbit.actors.cluster.NodeAddress;
import cloud.orbit.actors.cluster.NodeAddressImpl;
import cloud.orbit.actors.cluster.ViewListener;
import cloud.orbit.concurrent.Task;
import cloud.orbit.exception.UncheckedException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinTask;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.fork.ForkChannel;
import org.jgroups.protocols.FORK;
import org.jgroups.protocols.FRAG2;
import org.jgroups.protocols.UDP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsClusterPeer
implements ClusterPeer {
    private static final Logger logger = LoggerFactory.getLogger(JGroupsClusterPeer.class);
    private int portRangeLength = 1000;
    private Task<Address> startFuture;
    private ForkChannel channel;
    private DefaultCacheManager cacheManager;
    private NodeInfo local;
    private NodeInfo master;
    private volatile Map<Address, NodeInfo> nodeMap = new HashMap<Address, NodeInfo>();
    private volatile Map<NodeAddress, NodeInfo> nodeMap2 = new HashMap<NodeAddress, NodeInfo>();
    private ViewListener viewListener;
    private MessageListener messageListener;
    private String jgroupsConfig = "classpath:/conf/jgroups.xml";
    private boolean nameBasedUpdPort = true;

    public NodeAddress localAddress() {
        this.sync();
        return this.local.nodeAddress;
    }

    public void registerViewListener(ViewListener viewListener) {
        this.viewListener = viewListener;
    }

    public void registerMessageReceiver(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public Task<?> join(final String clusterName, final String nodeName) {
        ForkJoinTask<Address> f = ForkJoinTask.adapt(new Callable<Address>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Address call() {
                try {
                    JChannel udp;
                    if (System.getProperty("java.net.preferIPv4Stack", null) == null) {
                        System.setProperty("java.net.preferIPv4Stack", "true");
                    }
                    JChannel baseChannel = new JChannel(JGroupsClusterPeer.this.configToURL(JGroupsClusterPeer.this.getJgroupsConfig()));
                    baseChannel.setName(nodeName);
                    if (JGroupsClusterPeer.this.isNameBasedUpdPort() && baseChannel.getProtocolStack().getBottomProtocol() instanceof UDP) {
                        udp = (UDP)baseChannel.getProtocolStack().getBottomProtocol();
                        udp.setMulticastPort(udp.getMulticastPort() + (clusterName.hashCode() & 0x8FFFFFFF) % JGroupsClusterPeer.this.portRangeLength);
                    }
                    udp = baseChannel;
                    synchronized (udp) {
                        ProtocolStack stack = baseChannel.getProtocolStack();
                        FORK fork = (FORK)stack.findProtocol(FORK.class);
                        if (fork == null) {
                            fork = new FORK();
                            fork.setProtocolStack(stack);
                            stack.insertProtocol((Protocol)fork, 1, FRAG2.class);
                        }
                    }
                    JGroupsClusterPeer.this.channel = new ForkChannel((Channel)baseChannel, "hijack-stack", "lead-hijacker", true, 1, FRAG2.class, new Protocol[0]);
                    JGroupsClusterPeer.this.channel.setReceiver((Receiver)new ReceiverAdapter(){

                        public void viewAccepted(View view) {
                            JGroupsClusterPeer.this.doViewAccepted(view);
                        }

                        public void receive(Message msg) {
                            JGroupsClusterPeer.this.doReceive(msg);
                        }
                    });
                    GlobalConfigurationBuilder globalConfigurationBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
                    globalConfigurationBuilder.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true));
                    globalConfigurationBuilder.transport().clusterName(clusterName).nodeName(nodeName).transport((Transport)new JGroupsTransport((Channel)baseChannel));
                    ConfigurationBuilder builder = new ConfigurationBuilder();
                    builder.clustering().cacheMode(CacheMode.DIST_ASYNC);
                    JGroupsClusterPeer.this.cacheManager = new DefaultCacheManager(globalConfigurationBuilder.build(), builder.build());
                    JGroupsClusterPeer.this.cacheManager.getCache("distributedDirectory");
                    JGroupsClusterPeer.this.channel.connect(clusterName);
                    JGroupsClusterPeer.this.local = new NodeInfo(JGroupsClusterPeer.this.channel.getAddress());
                    logger.info("Registering the local address");
                    logger.info("Done with JGroups initialization");
                    return JGroupsClusterPeer.this.local.address;
                }
                catch (Exception e) {
                    logger.error("Error during JGroups initialization", (Throwable)e);
                    throw new UncheckedException((Throwable)e);
                }
            }
        });
        this.startFuture = Task.fromFuture(f);
        f.fork();
        return this.startFuture;
    }

    private URL configToURL(String jgroupsConfig) throws MalformedURLException {
        if (jgroupsConfig.startsWith("classpath:")) {
            String resourcePath = jgroupsConfig.substring("classpath:".length());
            URL resource = this.getClass().getResource(resourcePath);
            if (resource == null) {
                throw new IllegalArgumentException("Can't find classpath resource: " + resourcePath);
            }
            return resource;
        }
        if (!jgroupsConfig.contains(":")) {
            return Paths.get(jgroupsConfig, new String[0]).toUri().toURL();
        }
        return new URL(jgroupsConfig);
    }

    public void leave() {
        this.channel.close();
        this.channel = null;
        this.cacheManager.stop();
    }

    private void sync() {
        if (this.startFuture != null && !this.startFuture.isDone()) {
            this.startFuture.join();
        }
    }

    private void doViewAccepted(View view) {
        LinkedHashMap<Address, NodeInfo> newNodes = new LinkedHashMap<Address, NodeInfo>(view.size());
        LinkedHashMap<NodeAddress, NodeInfo> newNodes2 = new LinkedHashMap<NodeAddress, NodeInfo>(view.size());
        for (Address a : view) {
            NodeInfo info = this.nodeMap.get(a);
            if (info == null) {
                info = new NodeInfo(a);
            }
            newNodes.put(a, info);
            newNodes2.put(info.nodeAddress, info);
        }
        NodeInfo newMaster = (NodeInfo)newNodes.values().iterator().next();
        this.nodeMap = Collections.unmodifiableMap(newNodes);
        this.nodeMap2 = Collections.unmodifiableMap(newNodes2);
        this.master = newMaster;
        this.viewListener.onViewChange(this.nodeMap2.keySet());
    }

    public void sendMessage(NodeAddress address, byte[] message) {
        this.sync();
        try {
            Objects.requireNonNull(address, "node address");
            NodeInfo node = this.nodeMap2.get(address);
            if (node == null) {
                throw new IllegalArgumentException("Cluster node not found: " + address);
            }
            ForkChannel channel = this.channel;
            if (channel == null || !channel.isOpen()) {
                throw new IllegalStateException("Cluster not connected");
            }
            channel.send(node.address, message);
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public <K, V> ConcurrentMap<K, V> getCache(String name) {
        return this.cacheManager.getCache(name);
    }

    protected void doReceive(Message msg) {
        NodeInfo nodeInfo = this.nodeMap.get(msg.getSrc());
        if (nodeInfo == null) {
            logger.warn("Received message from invalid address {}", (Object)msg.getSrc());
            this.messageListener.receive((NodeAddress)new NodeAddressImpl(new UUID(((org.jgroups.util.UUID)msg.getSrc()).getMostSignificantBits(), ((org.jgroups.util.UUID)msg.getSrc()).getLeastSignificantBits())), msg.getBuffer());
        } else {
            this.messageListener.receive(nodeInfo.nodeAddress, msg.getBuffer());
        }
    }

    public NodeAddress getMaster() {
        return this.master != null ? this.master.nodeAddress : null;
    }

    public String getJgroupsConfig() {
        return this.jgroupsConfig;
    }

    public void setJgroupsConfig(String jgroupsConfig) {
        this.jgroupsConfig = jgroupsConfig;
    }

    public boolean isNameBasedUpdPort() {
        return this.nameBasedUpdPort;
    }

    public void setNameBasedUpdPort(boolean nameBasedUpdPort) {
        this.nameBasedUpdPort = nameBasedUpdPort;
    }

    public int getPortRangeLength() {
        return this.portRangeLength;
    }

    public void setPortRangeLength(int portRangeLength) {
        this.portRangeLength = portRangeLength;
    }

    protected static class NodeInfo {
        private Address address;
        private NodeAddress nodeAddress;

        public NodeInfo(Address address) {
            this.address = address;
            org.jgroups.util.UUID jgroupsUUID = (org.jgroups.util.UUID)address;
            this.nodeAddress = new NodeAddressImpl(new UUID(jgroupsUUID.getMostSignificantBits(), jgroupsUUID.getLeastSignificantBits()));
        }
    }
}

