/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.container.config;

import cloud.orbit.container.config.ContainerConfig;
import cloud.orbit.container.config.ContainerConfigImpl;
import cloud.orbit.exception.UncheckedException;
import cloud.orbit.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class YAMLConfigReader {
    public static ContainerConfig readConfig() {
        ContainerConfigImpl newConfig = new ContainerConfigImpl();
        newConfig.putAll((Map<?, ?>)System.getProperties());
        try {
            Set<String> activeProfiles;
            Map<String, Object> props;
            URL res = ContainerConfig.class.getResource("/conf/orbit.yaml");
            if (res != null && (props = YAMLConfigReader.readProperties(activeProfiles = Stream.of(System.getProperty("orbit.profiles", "").split(",")).collect(Collectors.toSet()), res.openStream())) != null) {
                newConfig.putAll(props);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return newConfig;
    }

    private static Map<String, Object> readProperties(Set<String> activeProfiles, InputStream in) throws IOException {
        String inputStreamString = IOUtils.toString((Reader)new InputStreamReader(in, "UTF-8"));
        Yaml yaml = new Yaml();
        yaml.setBeanAccess(BeanAccess.FIELD);
        Iterable iter = yaml.loadAll(YAMLConfigReader.substituteVariables(inputStreamString));
        LinkedHashMap<String, Object> newProperties = new LinkedHashMap<String, Object>();
        iter.forEach(item -> {
            Map section = (Map)item;
            Object sectionProfile = section.get("orbit.profile");
            if (sectionProfile == null || activeProfiles.contains(sectionProfile)) {
                newProperties.putAll(section);
            }
        });
        return newProperties;
    }

    private static String substituteVariables(String input) {
        StringBuilder sb = new StringBuilder(input);
        int endIndex = -1;
        int startIndex = sb.indexOf("${");
        while (startIndex > -1) {
            endIndex = sb.indexOf("}", startIndex);
            if (endIndex == -1) {
                throw new UncheckedException("Invalid config file. Could not find a closing curly bracket '}' for variable at line:" + sb.substring(0, startIndex).split("\n").length);
            }
            String propertyString = sb.substring(startIndex + 2, endIndex);
            if (propertyString.indexOf(10) > -1) {
                throw new UncheckedException("Invalid config file. File contains multi-line variable, possibly missing curly bracket '}' at line: " + sb.substring(0, startIndex).split("\n").length);
            }
            String variableReplacement = YAMLConfigReader.getProperty(propertyString);
            if (variableReplacement == null) {
                throw new UncheckedException("Could not find a value for property '" + propertyString + "'");
            }
            sb.replace(startIndex, endIndex + 1, variableReplacement);
            endIndex = startIndex + variableReplacement.length();
            startIndex = sb.indexOf("${", endIndex);
        }
        return sb.toString();
    }

    private static String getProperty(String propertyString) {
        int index = propertyString.indexOf(58);
        if (index > -1) {
            String propertyName = propertyString.substring(0, index);
            String defaultValue = propertyString.substring(index + 1);
            if (defaultValue != null && !defaultValue.isEmpty()) {
                defaultValue = defaultValue.trim();
            }
            return YAMLConfigReader.getSystemOrEnvironmentVar(propertyName, defaultValue);
        }
        return YAMLConfigReader.getSystemOrEnvironmentVar(propertyString, null);
    }

    private static String getSystemOrEnvironmentVar(String propertyName, String defaultValue) {
        String returnValue = System.getProperty(propertyName);
        if (returnValue == null) {
            returnValue = System.getenv(propertyName);
        }
        if (returnValue == null) {
            returnValue = defaultValue;
        }
        return returnValue;
    }
}

