/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.container.addons;

import cloud.orbit.actors.extensions.hk2.HK2LifetimeExtension;
import cloud.orbit.container.Container;
import cloud.orbit.container.addons.Addon;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class HK2Addon
implements Addon {
    private static final String STAGE_CLASS = "cloud.orbit.actors.Stage";
    private static final String EXTENSION_CLASS = "cloud.orbit.actors.extensions.ActorExtension";
    private static final String ADD_EXTENSION_METHOD = "addExtension";

    @Override
    public List<String> getClassesToScan() {
        ArrayList<String> classes = new ArrayList<String>();
        try {
            Class<?> stageClass = Class.forName(STAGE_CLASS);
            classes.add(stageClass.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return classes;
    }

    @Override
    public void configure(Container container) {
        try {
            Class<?> stageClass = Class.forName(STAGE_CLASS);
            Class<?> extensionClass = Class.forName(EXTENSION_CLASS);
            Object stage = container.get(stageClass);
            if (stage != null) {
                Method addExtensionMethod = stageClass.getMethod(ADD_EXTENSION_METHOD, extensionClass);
                addExtensionMethod.invoke(stage, new HK2LifetimeExtension(container));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }
}

