/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.container;

import cloud.orbit.annotation.Config;
import cloud.orbit.concurrent.Task;
import cloud.orbit.container.addons.Addon;
import cloud.orbit.container.config.ContainerConfig;
import cloud.orbit.container.config.YAMLConfigReader;
import cloud.orbit.exception.UncheckedException;
import cloud.orbit.lifecycle.Startable;
import cloud.orbit.reflect.ClassCache;
import cloud.orbit.reflect.FieldDescriptor;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.annotations.Service;

@Singleton
public class Container
implements Startable {
    private static final Logger logger = Logger.getLogger(Container.class.getName());
    private ServiceLocator serviceLocator;
    private ContainerConfig config;
    private String containerName = "orbit-container";
    private List<Class<?>> discoveredClasses = new ArrayList();
    private List<Object> discoveredServices = new ArrayList<Object>();
    private List<Addon> discoveredAddons = new ArrayList<Addon>();
    private List<String> packagesToScan = new ArrayList<String>();
    private List<String> classesToScan = new ArrayList<String>();

    public Container() {
    }

    public Container(String containerName) {
        this.setContainerName(containerName);
    }

    public Task start() {
        logger.info("Starting Orbit Container");
        try {
            this.config = YAMLConfigReader.readConfig();
            ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();
            this.serviceLocator = factory.create(this.containerName);
            ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.getServiceLocator(), (Object)this);
            this.discoverAddons();
            this.crawlPackages();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.toString());
        }
        this.initServices();
        logger.info("Container successfully started");
        return Task.done();
    }

    public Task stop() {
        this.destroyServices();
        return Task.done();
    }

    private void discoverAddons() throws IOException, InstantiationException, IllegalAccessException {
        ClassPath classPath = ClassPath.from((ClassLoader)Container.class.getClassLoader());
        ImmutableSet classInfos = classPath.getTopLevelClassesRecursive("cloud.orbit.container.addons");
        for (ClassPath.ClassInfo classInfo : classInfos) {
            Class addonClass = classInfo.load();
            if (addonClass.isInterface() || !Addon.class.isAssignableFrom(addonClass)) continue;
            Addon addon = (Addon)addonClass.newInstance();
            this.packagesToScan.addAll(addon.getPackagesToScan());
            this.classesToScan.addAll(addon.getClassesToScan());
            this.discoveredAddons.add(addon);
        }
    }

    private void initServices() {
        for (Addon addon : this.discoveredAddons) {
            addon.configure(this);
        }
        for (Object service : this.discoveredServices) {
            this.inject(service);
            this.getServiceLocator().postConstruct(service);
            if (!(service instanceof Startable)) continue;
            ((Startable)service).start().join();
        }
    }

    private void destroyServices() {
        for (Object service : this.discoveredServices) {
            this.getServiceLocator().preDestroy(service);
            if (!(service instanceof Startable)) continue;
            ((Startable)service).stop().join();
        }
    }

    private void crawlPackages() throws Exception {
        this.getDiscoveredClasses().clear();
        this.getDiscoveredServices().clear();
        ClassPath classPath = ClassPath.from((ClassLoader)Container.class.getClassLoader());
        ArrayList<String> packages = new ArrayList<String>();
        List<String> configPackages = this.config.getAsList("orbit.container.packages", String.class);
        if (configPackages != null) {
            packages.addAll(configPackages);
        }
        if (this.packagesToScan != null) {
            packages.addAll(this.packagesToScan);
        }
        for (String currentPackage : packages) {
            ImmutableSet classInfos = classPath.getTopLevelClassesRecursive(currentPackage);
            for (ClassPath.ClassInfo classInfo : classInfos) {
                Class loadedClass = classInfo.load();
                this.processClass(loadedClass);
            }
        }
        ArrayList<String> classes = new ArrayList<String>();
        List<String> configClasses = this.config.getAsList("orbit.container.classes", String.class);
        if (configClasses != null) {
            classes.addAll(configClasses);
        }
        if (this.classesToScan != null) {
            classes.addAll(this.classesToScan);
        }
        for (String currentClass : classes) {
            this.processClass(Class.forName(currentClass));
        }
    }

    private <T> T processClass(Class<?> classType) throws InstantiationException, IllegalAccessException {
        if (!this.discoveredClasses.contains(classType)) {
            Class<?>[] childClasses;
            this.discoveredClasses.add(classType);
            if (classType.isAnnotationPresent(Singleton.class) || classType.isAnnotationPresent(Service.class)) {
                Object o = this.config.getAsInstance(classType.getName(), Object.class);
                if (o == null) {
                    o = classType.newInstance();
                }
                this.discoveredServices.add(o);
                ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.getServiceLocator(), (Object)o);
                return (T)o;
            }
            for (Class<?> childClass : childClasses = classType.getClasses()) {
                this.processClass(childClass);
            }
        }
        return null;
    }

    public void inject(Object o) {
        this.inject(o, true);
    }

    public void inject(Object o, boolean injectConfig) {
        if (this.serviceLocator != null) {
            this.serviceLocator.inject(o);
        }
        if (injectConfig) {
            try {
                this.injectConfig(o);
            }
            catch (IllegalAccessException e) {
                throw new UncheckedException((Throwable)e);
            }
        }
    }

    protected void injectConfig(Object o) throws IllegalAccessException {
        for (FieldDescriptor fd : ClassCache.shared.getClass(o.getClass()).getAllInstanceFields()) {
            this.injectConfig(o, fd.getField());
        }
    }

    protected void injectConfig(Object o, Field f) throws IllegalAccessException {
        Config configAnnotation = f.getAnnotation(Config.class);
        if (configAnnotation != null) {
            if (Modifier.isFinal(f.getModifiers())) {
                throw new RuntimeException("Configurable fields should never be final: " + f);
            }
            f.setAccessible(true);
            if (f.getType() == Integer.TYPE || f.getType() == Integer.class) {
                f.set(o, this.config.getAsInt(configAnnotation.value(), (Integer)f.get(o)));
            } else if (f.getType() == Boolean.TYPE || f.getType() == Boolean.class) {
                f.set(o, this.config.getAsBoolean(configAnnotation.value(), (Boolean)f.get(o)));
            } else if (f.getType() == Long.TYPE || f.getType() == Long.class) {
                f.set(o, this.config.getAsLong(configAnnotation.value(), (Long)f.get(o)));
            } else if (f.getType() == String.class) {
                f.set(o, this.config.getAsString(configAnnotation.value(), (String)f.get(o)));
            } else if (f.getType().isEnum()) {
                String enumValue = this.config.getAsString(configAnnotation.value(), null);
                if (enumValue != null) {
                    f.set(o, Enum.valueOf(f.getType(), enumValue));
                }
            } else if (List.class.isAssignableFrom(f.getType())) {
                if (this.config.getAll().get(configAnnotation.value()) != null) {
                    Object val = this.config.getAll().get(configAnnotation.value());
                    f.set(o, val);
                }
            } else if (Set.class.isAssignableFrom(f.getType())) {
                if (this.config.getAll().get(configAnnotation.value()) != null) {
                    Object val = this.config.getAll().get(configAnnotation.value());
                    if (val instanceof List) {
                        f.set(o, new LinkedHashSet((List)val));
                    } else {
                        f.set(o, val);
                    }
                }
            } else if (this.config.getAll().get(configAnnotation.value()) != null) {
                Object val = this.config.getAll().get(configAnnotation.value());
                f.set(o, val);
            } else {
                throw new UncheckedException("Field type not supported for configuration injection: " + f);
            }
        }
    }

    public <T> T get(Class<T> clazz) {
        return this.get(clazz, false);
    }

    public <T> T get(Class<T> clazz, boolean shouldCreateInstance) {
        Object o = this.serviceLocator.getService(clazz, new Annotation[0]);
        if (o == null && shouldCreateInstance) {
            try {
                o = clazz.newInstance();
                this.inject(o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (T)o;
    }

    public void addClassToScan(Class classType) {
        this.addClassToScan(classType.getName());
    }

    public void addClassToScan(String className) {
        this.classesToScan.add(className);
    }

    public void addPackageToScan(String packageName) {
        this.packagesToScan.add(packageName);
    }

    public List<Class<?>> getDiscoveredClasses() {
        return this.discoveredClasses;
    }

    public List<Object> getDiscoveredServices() {
        return this.discoveredServices;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }
}

