/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.plugin.gradle;

import cloud.orbit.plugin.gradle.OrbitDslCompilerRunner;
import cloud.orbit.plugin.gradle.OrbitDslSpec;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GFileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcloud/orbit/plugin/gradle/OrbitDslTask;", "Lorg/gradle/api/tasks/SourceTask;", "()V", "outputDirectory", "Ljava/io/File;", "getOutputDirectory", "()Ljava/io/File;", "setOutputDirectory", "(Ljava/io/File;)V", "sourceDirectorySet", "Lorg/gradle/api/file/SourceDirectorySet;", "execute", "", "setSource", "source", "", "orbit-gradle-plugin"})
public class OrbitDslTask
extends SourceTask {
    @OutputDirectory
    @Nullable
    private File outputDirectory;
    private SourceDirectorySet sourceDirectorySet;

    @Nullable
    public final File getOutputDirectory() {
        return this.outputDirectory;
    }

    public final void setOutputDirectory(@Nullable File file) {
        this.outputDirectory = file;
    }

    @TaskAction
    public final void execute() {
        Set orbitFiles = new LinkedHashSet();
        FileTree fileTree = this.getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"source");
        Set sourceFiles = fileTree.getFiles();
        File file = this.outputDirectory;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        GFileUtils.cleanDirectory((File)file);
        Set set = sourceFiles;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"sourceFiles");
        orbitFiles.addAll(set);
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file2 = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"project.projectDir");
        SourceDirectorySet sourceDirectorySet = this.sourceDirectorySet;
        if (sourceDirectorySet == null) {
            Intrinsics.throwNpe();
        }
        Set set2 = sourceDirectorySet.getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"sourceDirectorySet!!.srcDirs");
        File file3 = this.outputDirectory;
        if (file3 == null) {
            Intrinsics.throwNpe();
        }
        OrbitDslSpec spec = new OrbitDslSpec(file2, orbitFiles, set2, file3);
        new OrbitDslCompilerRunner().run(spec);
    }

    public void setSource(@NotNull Object source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        super.setSource(source);
        if (source instanceof SourceDirectorySet) {
            this.sourceDirectorySet = (SourceDirectorySet)source;
        }
    }
}

