/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.dynamodb;

import cloud.orbit.actors.extensions.StorageExtension;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBConfiguration;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBConnection;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBStateConfiguration;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBUtils;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.concurrent.Task;
import cloud.orbit.exception.UncheckedException;
import cloud.orbit.util.StringUtils;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.spec.GetItemSpec;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class DynamoDBStorageExtension
implements StorageExtension {
    public static final String DOCUMENT_ID_DECORATION_SEPARATOR = "/";
    private String name = "default";
    private DynamoDBConnection dynamoDBConnection;
    private DynamoDBConfiguration dynamoDBConfiguration = new DynamoDBConfiguration();
    private String defaultTableName = "orbit";

    public DynamoDBStorageExtension() {
        this.dynamoDBConfiguration = new DynamoDBConfiguration();
    }

    public DynamoDBStorageExtension(DynamoDBConfiguration dynamoDBConfiguration) {
        this.dynamoDBConfiguration = dynamoDBConfiguration;
    }

    public Task<Void> start() {
        this.dynamoDBConnection = new DynamoDBConnection(this.dynamoDBConfiguration);
        DynamoDBUtils.getTable(this.dynamoDBConnection, this.defaultTableName).join();
        return Task.done();
    }

    public Task<Void> stop() {
        return Task.done();
    }

    public Task<Void> clearState(RemoteReference<?> reference, Object state) {
        return this.clearState(reference, state, state.getClass());
    }

    public Task<Void> clearState(RemoteReference<?> reference, Object state, Class<?> stateClass) {
        String tableName = this.getTableName(RemoteReference.getInterfaceClass(reference), stateClass);
        String itemId = this.generateDocumentId(reference, stateClass);
        return DynamoDBUtils.getTable(this.dynamoDBConnection, tableName).thenAccept(table -> table.deleteItem("_id", (Object)itemId));
    }

    public Task<Boolean> readState(RemoteReference<?> reference, Object state) {
        return this.readState(reference, state, state.getClass());
    }

    public Task<Boolean> readState(RemoteReference<?> reference, Object state, Class<?> stateClass) {
        ObjectMapper mapper = this.dynamoDBConnection.getMapper();
        String tableName = this.getTableName(RemoteReference.getInterfaceClass(reference), stateClass);
        String itemId = this.generateDocumentId(reference, stateClass);
        return DynamoDBUtils.getTable(this.dynamoDBConnection, tableName).thenApply(table -> {
            GetItemSpec getItemSpec = new GetItemSpec().withPrimaryKey("_id", (Object)itemId).withConsistentRead(true);
            return table.getItem(getItemSpec);
        }).thenApply(item -> {
            if (item != null) {
                this.readStateInternal(state, stateClass, (Item)item, mapper);
                return true;
            }
            return false;
        });
    }

    public Task<Void> writeState(RemoteReference<?> reference, Object state) {
        return this.writeState(reference, state, state.getClass());
    }

    public Task<Void> writeState(RemoteReference<?> reference, Object state, Class<?> stateClass) {
        Class referenceType = RemoteReference.getInterfaceClass(reference);
        String tableName = this.getTableName(referenceType, stateClass);
        String itemId = this.generateDocumentId(reference, stateClass);
        return DynamoDBUtils.getTable(this.dynamoDBConnection, tableName).thenAccept(table -> {
            Item newItem = this.generatePutItem(reference, state, stateClass, itemId, this.dynamoDBConnection.getMapper());
            table.putItem(newItem);
        });
    }

    public String getName() {
        return this.name;
    }

    public String generateDocumentId(RemoteReference<?> reference, Class<?> stateClass) {
        Class referenceClass = RemoteReference.getInterfaceClass(reference);
        String idDecoration = this.getIdDecoration(stateClass, referenceClass.getName());
        String documentId = String.format("%s%s%s", String.valueOf(RemoteReference.getId(reference)), DOCUMENT_ID_DECORATION_SEPARATOR, idDecoration);
        return documentId;
    }

    public String getIdDecoration(Class<?> stateClass, String defaultIdDecoration) {
        DynamoDBStateConfiguration dynamoDBStateConfiguration = stateClass.getAnnotation(DynamoDBStateConfiguration.class);
        if (dynamoDBStateConfiguration != null && StringUtils.isNotBlank((CharSequence)dynamoDBStateConfiguration.idDecorationOverride())) {
            return dynamoDBStateConfiguration.idDecorationOverride();
        }
        return defaultIdDecoration;
    }

    public String getTableName(Class<?> referenceType, Class<?> stateType) {
        DynamoDBStateConfiguration dynamoDBStateConfiguration = stateType.getAnnotation(DynamoDBStateConfiguration.class);
        if (dynamoDBStateConfiguration != null && StringUtils.isNotBlank((CharSequence)dynamoDBStateConfiguration.collection())) {
            return dynamoDBStateConfiguration.collection();
        }
        return this.defaultTableName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultTableName() {
        return this.defaultTableName;
    }

    public void setDefaultTableName(String defaultTableName) {
        this.defaultTableName = defaultTableName;
    }

    protected DynamoDBConnection getDynamoDBConnection() {
        return this.dynamoDBConnection;
    }

    protected void readStateInternal(Object state, Class<?> stateClass, Item item, ObjectMapper mapper) {
        try {
            if (!state.getClass().equals(stateClass)) {
                throw new IllegalArgumentException(String.format("State class (%s) did not match expected class (%s), Storage Extension should override generatePutItem method", state.getClass().getName(), stateClass.getName()));
            }
            mapper.readerForUpdating(state).readValue(item.getJSON("_state"));
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    protected Item generatePutItem(RemoteReference<?> reference, Object state, Class<?> stateClass, String itemId, ObjectMapper mapper) {
        try {
            if (state != null && !state.getClass().equals(stateClass)) {
                throw new IllegalArgumentException(String.format("State class (%s) did not match expected class (%s), Storage Extension should override generatePutItem method", state.getClass().getName(), stateClass.getName()));
            }
            Class referenceType = RemoteReference.getInterfaceClass(reference);
            Item item = new Item().withPrimaryKey("_id", (Object)itemId).with("_owningType", (Object)referenceType.getName());
            if (state != null) {
                String serializedState = mapper.writeValueAsString(state);
                item.withJSON("_state", serializedState);
            }
            return item;
        }
        catch (JsonProcessingException e) {
            throw new UncheckedException((Throwable)e);
        }
    }
}

