/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.dynamodb;

import cloud.orbit.actors.extensions.dynamodb.AWSConfigValue;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBConfiguration;
import cloud.orbit.actors.extensions.json.ActorReferenceModule;
import cloud.orbit.actors.runtime.DefaultDescriptorFactory;
import cloud.orbit.util.StringUtils;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsyncClient;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;

public class DynamoDBConnection {
    private static final String EMPTY_STRING_PLACEHOLDER = "OrbitEmptyString.2f748e4e-c8ef-4129-8dbc-206fe8e72e64";
    public static final byte[] EMPTY_BYTE_ARRAY_PLACEHOLDER = "OrbitEmptyByteArray.a643e4a1-96dc-45b3-9606-479bae6bb3f2".getBytes();
    private AmazonDynamoDBAsyncClient dynamoClient;
    private DynamoDB dynamoDB;
    private ObjectMapper mapper;
    private UUID connectionId = UUID.randomUUID();

    public DynamoDBConnection(DynamoDBConfiguration dynamoDBConfiguration) {
        this.initializeDynamoDB(dynamoDBConfiguration);
        this.initializeMapper();
    }

    public AmazonDynamoDBAsyncClient getDynamoClient() {
        return this.dynamoClient;
    }

    public DynamoDB getDynamoDB() {
        return this.dynamoDB;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    private void initializeMapper() {
        SimpleModule serializersModule = this.createSerializersForMapper();
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new ActorReferenceModule(DefaultDescriptorFactory.get()));
        this.mapper.registerModule((Module)serializersModule);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.setVisibility(this.mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private SimpleModule createSerializersForMapper() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(String.class, (JsonSerializer)new JsonSerializer<String>(){

            public void serialize(String stringValue, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                if (stringValue.equals("")) {
                    jsonGenerator.writeString(DynamoDBConnection.EMPTY_STRING_PLACEHOLDER);
                } else {
                    jsonGenerator.writeString(stringValue);
                }
            }
        });
        module.addDeserializer(String.class, (JsonDeserializer)new JsonDeserializer<String>(){

            public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
                String value = jsonParser.getValueAsString();
                return value.equals(DynamoDBConnection.EMPTY_STRING_PLACEHOLDER) ? "" : value;
            }
        });
        module.addSerializer(byte[].class, (JsonSerializer)new JsonSerializer<byte[]>(){

            public void serialize(byte[] byteArrayValue, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                if (byteArrayValue.length > 0) {
                    jsonGenerator.writeBinary(byteArrayValue);
                } else {
                    jsonGenerator.writeBinary(EMPTY_BYTE_ARRAY_PLACEHOLDER);
                }
            }
        });
        module.addDeserializer(byte[].class, (JsonDeserializer)new JsonDeserializer<byte[]>(){

            public byte[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
                byte[] value = jsonParser.getBinaryValue();
                if (Arrays.equals(value, EMPTY_BYTE_ARRAY_PLACEHOLDER)) {
                    return new byte[0];
                }
                return value;
            }
        });
        return module;
    }

    private void initializeDynamoDB(DynamoDBConfiguration dynamoDBConfiguration) {
        switch (dynamoDBConfiguration.getCredentialType()) {
            case BASIC_CREDENTIALS: {
                this.dynamoClient = new AmazonDynamoDBAsyncClient((AWSCredentials)new BasicAWSCredentials(dynamoDBConfiguration.getAccessKey(), dynamoDBConfiguration.getSecretKey()));
                break;
            }
            case BASIC_SESSION_CREDENTIALS: {
                this.dynamoClient = new AmazonDynamoDBAsyncClient((AWSCredentials)new BasicSessionCredentials(dynamoDBConfiguration.getAccessKey(), dynamoDBConfiguration.getSecretKey(), dynamoDBConfiguration.getSessionToken()));
                break;
            }
            default: {
                this.dynamoClient = new AmazonDynamoDBAsyncClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
            }
        }
        String awsRegion = StringUtils.defaultIfBlank((String)dynamoDBConfiguration.getRegion(), (String)AWSConfigValue.getRegion());
        if (StringUtils.isNotBlank((CharSequence)awsRegion)) {
            this.dynamoClient.setRegion(Region.getRegion((Regions)Regions.fromName((String)awsRegion)));
        }
        if (StringUtils.isNotBlank((CharSequence)dynamoDBConfiguration.getEndpoint())) {
            this.dynamoClient.setEndpoint(dynamoDBConfiguration.getEndpoint());
        }
        this.dynamoDB = new DynamoDB((AmazonDynamoDB)this.dynamoClient);
    }

    public UUID getConnectionId() {
        return this.connectionId;
    }
}

