/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.dynamodb;

import cloud.orbit.actors.extensions.StorageExtension;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBConfiguration;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBConnection;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBStateConfiguration;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBUtils;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.concurrent.Task;
import cloud.orbit.exception.UncheckedException;
import cloud.orbit.util.StringUtils;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.spec.GetItemSpec;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class DynamoDBStorageExtension
implements StorageExtension {
    public static final String DOCUMENT_ID_DECORATION_SEPARATOR = "/";
    private String name = "default";
    private DynamoDBConnection dynamoDBConnection;
    private DynamoDBConfiguration dynamoDBConfiguration = new DynamoDBConfiguration();
    private String defaultTableName = "orbit";

    public DynamoDBStorageExtension() {
        this.dynamoDBConfiguration = new DynamoDBConfiguration();
    }

    public DynamoDBStorageExtension(DynamoDBConfiguration dynamoDBConfiguration) {
        this.dynamoDBConfiguration = dynamoDBConfiguration;
    }

    public Task<Void> start() {
        this.dynamoDBConnection = new DynamoDBConnection(this.dynamoDBConfiguration);
        DynamoDBUtils.getTable(this.dynamoDBConnection, this.defaultTableName).join();
        return Task.done();
    }

    public Task<Void> stop() {
        return Task.done();
    }

    public Task<Void> clearState(RemoteReference<?> reference, Object state) {
        String tableName = this.getTableName(RemoteReference.getInterfaceClass(reference), state.getClass());
        String itemId = this.generateDocumentId(reference, state);
        return DynamoDBUtils.getTable(this.dynamoDBConnection, tableName).thenAccept(table -> table.deleteItem("_id", (Object)itemId));
    }

    public Task<Boolean> readState(RemoteReference<?> reference, Object state) {
        ObjectMapper mapper = this.dynamoDBConnection.getMapper();
        String tableName = this.getTableName(RemoteReference.getInterfaceClass(reference), state.getClass());
        String itemId = this.generateDocumentId(reference, state);
        return DynamoDBUtils.getTable(this.dynamoDBConnection, tableName).thenApply(table -> {
            GetItemSpec getItemSpec = new GetItemSpec().withPrimaryKey("_id", (Object)itemId).withConsistentRead(true);
            return table.getItem(getItemSpec);
        }).thenApply(item -> {
            if (item != null) {
                this.readStateInternal(state, (Item)item, mapper);
                return true;
            }
            return false;
        });
    }

    public Task<Void> writeState(RemoteReference<?> reference, Object state) {
        Class referenceType = RemoteReference.getInterfaceClass(reference);
        String tableName = this.getTableName(referenceType, state.getClass());
        String itemId = this.generateDocumentId(reference, state);
        return DynamoDBUtils.getTable(this.dynamoDBConnection, tableName).thenAccept(table -> {
            Item newItem = this.generatePutItem(reference, state, itemId, this.dynamoDBConnection.getMapper());
            table.putItem(newItem);
        });
    }

    public String getName() {
        return this.name;
    }

    public String generateDocumentId(RemoteReference<?> reference, Object state) {
        Class referenceClass = RemoteReference.getInterfaceClass(reference);
        String idDecoration = this.getIdDecoration(state, referenceClass.getName());
        String documentId = String.format("%s%s%s", String.valueOf(RemoteReference.getId(reference)), DOCUMENT_ID_DECORATION_SEPARATOR, idDecoration);
        return documentId;
    }

    public String getIdDecoration(Object state, String defaultIdDecoration) {
        DynamoDBStateConfiguration dynamoDBStateConfiguration;
        if (state != null && (dynamoDBStateConfiguration = state.getClass().getAnnotation(DynamoDBStateConfiguration.class)) != null && StringUtils.isNotBlank((CharSequence)dynamoDBStateConfiguration.idDecorationOverride())) {
            return dynamoDBStateConfiguration.idDecorationOverride();
        }
        return defaultIdDecoration;
    }

    public String getTableName(Class<?> referenceType, Class<?> stateType) {
        DynamoDBStateConfiguration dynamoDBStateConfiguration = stateType.getAnnotation(DynamoDBStateConfiguration.class);
        if (dynamoDBStateConfiguration != null && StringUtils.isNotBlank((CharSequence)dynamoDBStateConfiguration.collection())) {
            return dynamoDBStateConfiguration.collection();
        }
        return this.defaultTableName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultTableName() {
        return this.defaultTableName;
    }

    public void setDefaultTableName(String defaultTableName) {
        this.defaultTableName = defaultTableName;
    }

    protected DynamoDBConnection getDynamoDBConnection() {
        return this.dynamoDBConnection;
    }

    protected void readStateInternal(Object state, Item item, ObjectMapper mapper) {
        try {
            mapper.readerForUpdating(state).readValue(item.getJSON("_state"));
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    protected Item generatePutItem(RemoteReference<?> reference, Object state, String itemId, ObjectMapper mapper) {
        try {
            Class referenceType = RemoteReference.getInterfaceClass(reference);
            String serializedState = mapper.writeValueAsString(state);
            return new Item().withPrimaryKey("_id", (Object)itemId).with("_owningType", (Object)referenceType.getName()).withJSON("_state", serializedState);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedException((Throwable)e);
        }
    }
}

