/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.dynamodb;

import cloud.orbit.actors.extensions.dynamodb.DynamoDBConnection;
import cloud.orbit.concurrent.Task;
import cloud.orbit.exception.UncheckedException;
import cloud.orbit.util.ExceptionUtils;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;

public class DynamoDBUtils {
    private static final int WAITING_FOR_ACTIVE_TABLE_STATUS_MAX_ATTEMPTS = 66;
    static final long WAITING_FOR_ACTIVE_TABLE_STATUS_RETRY_DELAY_MILLIS = 600L;
    public static final String FIELD_NAME_PRIMARY_ID = "_id";
    public static final String FIELD_NAME_DATA = "_state";
    private static ConcurrentMap<String, Table> tableCache = new ConcurrentHashMap<String, Table>();

    public static Task<Table> getTable(DynamoDBConnection dynamoDBConnection, String tableName) {
        String tableCacheId = DynamoDBUtils.generateTableCacheId(dynamoDBConnection, tableName);
        Table table = (Table)tableCache.get(tableCacheId);
        if (table != null) {
            return Task.fromValue((Object)table);
        }
        return Task.fromFuture((Future)dynamoDBConnection.getDynamoClient().describeTableAsync(tableName)).thenApply(DescribeTableResult::getTable).thenCompose(descriptor -> {
            if (descriptor.getTableStatus().equals(TableStatus.CREATING.name())) {
                return DynamoDBUtils.waitForActiveTableStatus(dynamoDBConnection, tableName);
            }
            return Task.fromValue((Object)descriptor);
        }).thenApply(descriptor -> {
            Table retrievedTable = dynamoDBConnection.getDynamoDB().getTable(descriptor.getTableName());
            tableCache.putIfAbsent(tableCacheId, retrievedTable);
            return retrievedTable;
        }).exceptionally(e -> {
            if (e instanceof ResourceInUseException) {
                return (Table)DynamoDBUtils.getTable(dynamoDBConnection, tableName).join();
            }
            if (ExceptionUtils.isCauseInChain(ResourceNotFoundException.class, (Throwable)e)) {
                try {
                    DynamoDBUtils.createTable(dynamoDBConnection, tableName);
                    return (Table)DynamoDBUtils.getTable(dynamoDBConnection, tableName).join();
                }
                catch (ResourceInUseException resourceInUseException) {
                    return (Table)DynamoDBUtils.getTable(dynamoDBConnection, tableName).join();
                }
                catch (InterruptedException interruptedException) {
                    throw new UncheckedException((Throwable)interruptedException);
                }
            }
            throw new UncheckedException(e);
        });
    }

    private static Task<TableDescription> waitForActiveTableStatus(DynamoDBConnection dynamoDBConnection, String tableName) {
        try {
            for (int i = 0; i < 66; ++i) {
                DescribeTableResult describe = dynamoDBConnection.getDynamoClient().describeTable(tableName);
                if (describe.getTable().getTableStatus().equals(TableStatus.ACTIVE.name())) {
                    return Task.fromValue((Object)describe.getTable());
                }
                Thread.sleep(600L);
            }
        }
        catch (InterruptedException e) {
            throw new UncheckedException((Throwable)e);
        }
        throw new UncheckedException("Hit max retry attempts while waiting for table to become active: " + tableName);
    }

    private static Table createTable(DynamoDBConnection dynamoDBConnection, String tableName) throws InterruptedException {
        CreateTableRequest createTableRequest = DynamoDBUtils.createCreateTableRequest(tableName);
        Table table = dynamoDBConnection.getDynamoDB().createTable(createTableRequest);
        table.waitForActive();
        return table;
    }

    private static CreateTableRequest createCreateTableRequest(String tableName) {
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        ArrayList<AttributeDefinition> tableAttributes = new ArrayList<AttributeDefinition>();
        keySchema.add(new KeySchemaElement(FIELD_NAME_PRIMARY_ID, KeyType.HASH));
        tableAttributes.add(new AttributeDefinition(FIELD_NAME_PRIMARY_ID, ScalarAttributeType.S));
        return new CreateTableRequest().withTableName(tableName).withKeySchema(keySchema).withAttributeDefinitions(tableAttributes).withProvisionedThroughput(new ProvisionedThroughput(Long.valueOf(1L), Long.valueOf(1L)));
    }

    private static String generateTableCacheId(DynamoDBConnection dynamoDBConnection, String tableName) {
        return dynamoDBConnection.getConnectionId().toString() + "/" + tableName;
    }
}

