/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.dynamodb;

import cloud.orbit.actors.extensions.StorageExtension;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBConfiguration;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBConnection;
import cloud.orbit.actors.extensions.dynamodb.DynamoDBUtils;
import cloud.orbit.actors.runtime.RemoteReference;
import cloud.orbit.concurrent.Task;
import cloud.orbit.exception.UncheckedException;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class DynamoDBStorageExtension
implements StorageExtension {
    public static final String DOCUMENT_ID_DECORATION_SEPARATOR = "/";
    private String name = "default";
    private DynamoDBConnection dynamoDBConnection;
    private DynamoDBConfiguration dynamoDBConfiguration = new DynamoDBConfiguration();
    private String defaultTableName = "orbit";

    public DynamoDBStorageExtension() {
        this.dynamoDBConfiguration = new DynamoDBConfiguration();
    }

    public DynamoDBStorageExtension(DynamoDBConfiguration dynamoDBConfiguration) {
        this.dynamoDBConfiguration = dynamoDBConfiguration;
    }

    public Task<Void> start() {
        this.dynamoDBConnection = new DynamoDBConnection(this.dynamoDBConfiguration);
        DynamoDBUtils.getTable(this.dynamoDBConnection, this.defaultTableName).join();
        return Task.done();
    }

    public Task<Void> stop() {
        return Task.done();
    }

    public Task<Void> clearState(RemoteReference<?> reference, Object state) {
        String tableName = this.getTableName(RemoteReference.getInterfaceClass(reference), state.getClass());
        String itemId = this.generateDocumentId(reference);
        return DynamoDBUtils.getTable(this.dynamoDBConnection, tableName).thenAccept(table -> table.deleteItem("_id", (Object)itemId));
    }

    public Task<Boolean> readState(RemoteReference<?> reference, Object state) {
        ObjectMapper mapper = this.dynamoDBConnection.getMapper();
        String tableName = this.getTableName(RemoteReference.getInterfaceClass(reference), state.getClass());
        String itemId = this.generateDocumentId(reference);
        return DynamoDBUtils.getTable(this.dynamoDBConnection, tableName).thenApply(table -> table.getItem("_id", (Object)itemId)).thenApply(item -> {
            if (item != null) {
                try {
                    mapper.readerForUpdating(state).readValue(item.getJSON("_state"));
                    return true;
                }
                catch (IOException e) {
                    throw new UncheckedException((Throwable)e);
                }
            }
            return false;
        });
    }

    public Task<Void> writeState(RemoteReference<?> reference, Object state) {
        try {
            ObjectMapper mapper = this.dynamoDBConnection.getMapper();
            String serializedState = mapper.writeValueAsString(state);
            String tableName = this.getTableName(RemoteReference.getInterfaceClass(reference), state.getClass());
            String itemId = this.generateDocumentId(reference);
            return DynamoDBUtils.getTable(this.dynamoDBConnection, tableName).thenAccept(table -> {
                Item newItem = new Item().withPrimaryKey("_id", (Object)itemId).withJSON("_state", serializedState);
                table.putItem(newItem);
            });
        }
        catch (JsonProcessingException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String generateDocumentId(RemoteReference<?> reference) {
        Class referenceClass = RemoteReference.getInterfaceClass(reference);
        String idDecoration = referenceClass.getName();
        String documentId = String.format("%s%s%s", String.valueOf(RemoteReference.getId(reference)), DOCUMENT_ID_DECORATION_SEPARATOR, idDecoration);
        return documentId;
    }

    public String getTableName(Class<?> referenceType, Class<?> stateType) {
        return this.defaultTableName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultTableName() {
        return this.defaultTableName;
    }

    public void setDefaultTableName(String defaultTableName) {
        this.defaultTableName = defaultTableName;
    }
}

