/*
 * Decompiled with CFR 0.152.
 */
package cloud.orbit.actors.extensions.dynamodb;

import cloud.orbit.actors.extensions.dynamodb.AmazonCredentialType;

public class DynamoDBConfiguration {
    private AmazonCredentialType credentialType;
    private String accessKey;
    private String secretKey;
    private String sessionToken;
    private String region;
    private String endpoint;

    public AmazonCredentialType getCredentialType() {
        return this.credentialType;
    }

    public void setCredentialType(AmazonCredentialType credentialType) {
        this.credentialType = credentialType;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public static class Builder {
        private DynamoDBConfiguration dynamoConfig = new DynamoDBConfiguration();

        public Builder withCredentialType(AmazonCredentialType credentialType) {
            this.dynamoConfig.setCredentialType(credentialType);
            return this;
        }

        public Builder withAccessKey(String accessKey) {
            this.dynamoConfig.setAccessKey(accessKey);
            return this;
        }

        public Builder withSecretKey(String secretKey) {
            this.dynamoConfig.setSecretKey(secretKey);
            return this;
        }

        public Builder withSessionToken(String sessionToken) {
            this.dynamoConfig.setSessionToken(sessionToken);
            return this;
        }

        public Builder withRegion(String region) {
            this.dynamoConfig.setRegion(region);
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.dynamoConfig.setEndpoint(endpoint);
            return this;
        }

        public DynamoDBConfiguration build() {
            return this.dynamoConfig;
        }
    }
}

